(ns pinkgorilla.notebook-ui.notebook.segment
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.notebook-ui.eval-result.eval-result :refer [eval-result-view]]
   [pinkgorilla.notebook-ui.eval-result.code-viewer :refer [code-view]]
   [pinkgorilla.notebook-ui.eval-result.code :refer [code-edit]]
   [pinkgorilla.notebook-ui.notebook.codemirror :refer [codemirror-edit-inline]]
   [pinkgorilla.notebook-ui.notebook.md :refer [md-segment-edit md-segment-view]]
   [pinkgorilla.notebook-ui.completion.component :refer [completion-component]]
   [pinkgorilla.notebook-ui.notebook.segment-nav :refer [segment-nav]]))

;; input


(defn segment-input-md [active? eval-result]
  (if active?
    [md-segment-edit eval-result]
    [md-segment-view eval-result]))

(defn segment-input-code [{:keys [active? code-editor]} eval-result]
  [:div {:style {:position "relative"}} ; container for kernel absolute position
   ; kernel - one color for both dark and light themes.
   (when-let [kernel (:kernel eval-result)] ; snippets might not define kernel
     [:span.pr-2.text-right.text-blue-600.tracking-wide.font-bold.border.border-blue-300.rounded
      {:on-click #(dispatch [:segment/kernel-toggle])
       :style {:position "absolute"
               :z-index 200 ; dialog is 1040 (we have to be lower)
               :top "5px" ; not too big, so it works for single-row code segments
               :right "10px"
               :width "50px"
               :height "25px"}} kernel])
   (if active?
     (case code-editor
       :codemirror [codemirror-edit-inline eval-result]
       :text [code-edit eval-result]
       [code-edit eval-result])
     [code-view eval-result])])

(defn segment-input [{:keys [id code md] :as eval-result}]
  (let [settings (subscribe [:settings])
        {:keys [code-editor]
         :or {code-editor :codemirror}}  @settings
        segment-active (subscribe [:notebook/segment-active])
        active? (= (:id @segment-active) id)
        options {:active? active?
                 :code-editor code-editor}]
    [:div.text-left.bg-gray-100 ; .border-solid
     {:id id
      :on-click #(dispatch [:notebook/move :to id])
      :class (when active? "border border-solid border-red-600")}
     (cond
       code  [segment-input-code options eval-result]
       md [segment-input-md active? eval-result])]))

;; output

(defn segment-output [{:keys [code md] :as eval-result}]
  [:div
   (when md
     [md-segment-view eval-result])
   (when code
     [eval-result-view eval-result])])

;; layout

(defn layout-vertical [eval-result]
  [:div.w-full ; .mt-5.p-2
   [segment-input eval-result]
   [segment-output eval-result]])

(defn layout-horizontal [eval-result]
  [:div.w-full.flex.flex-row ; .mt-5.p-2
   [:div {:class "w-1/2"}
    [segment-input eval-result]]
   [:div {:class "w-1/2"}
    [segment-output eval-result]]])

(defn layout-single [{:keys [id] :as eval-result}]
  [:div.w-full.h-full.bg-red-200 ; if this is :<> then it can fuck up flexbox styling
     ; dynamically loading css will not work the first time
     ; the editor is shown. css might get rendered after codemirror. 
     ; left (code/code-completion) - right (result) 
   [:div.flex.flex-row.w-full.h-full.items-stretch ; .justify-between
      ; code-mirror / code-completion
    [:div.bg-orange-500.h-screen.flex.flex-col.items-stretch {:class "w-1/2"}
     ;[:div "segment:" id
     [segment-nav]
      ;]
     [:div.w-full.h-full.bg-red-300
      [segment-input eval-result]]
     [:div.h-64.w-full.bg-teal-300
      [completion-component]]]
      ; error / console / result
    [:div.bg-blue-700.h-screen {:class "w-1/2"}
     [segment-output eval-result]]]])

; segment

(defn segment-view [{:keys [id] :as eval-result}]
  (let [settings (subscribe [:settings])
        layout (or (:layout @settings) :vertical)]
    [:div {:id id}
     (case layout
       :vertical [layout-vertical eval-result]
       :horizontal [layout-horizontal eval-result]
       :single [layout-single eval-result]
       [layout-vertical eval-result])]))




