(ns pinkgorilla.notebook-ui.codemirror.options
  (:require
   [reagent.core :as r]))

(def settings (r/atom
               {:parinfer false
                :vim false
                :warning-as-error false}))

(def cm-default-opts
  {:lineNumbers true
   :firstLineNumber 1
   :lineWrapping true ;  false=scroll (horizontal), true=wrap 
   ; viewportMargin: Specifies the amount of lines that are rendered above and 
   ; below the part of the document that's currently scrolled into view. This 
   ; affects the amount of updates needed when scrolling, and the amount of 
   ; work that such an update does. You should usually leave it at its 
   ; default, 10. Can be set to Infinity to make sure the whole document is 
   ; always rendered, and thus the browser's text search works on it. This 
   ; will have bad effects on performance of big documents.
   ;:viewportMargin js/Infinity
   :matchBrackets true
   :autoCloseBrackets "()[]{}\"\""
   :autofocus true
   :showCursorWhenSelecting true
   :theme "paraiso-dark" ; "default" ; 
   :extraKeys #js {"Shift-Enter" "newlineAndIndent"}
   :mode (if (:parinfer @settings)
           "clojure-parinfer"
           "clojure")
   :keyMap (if (:vim @settings) "vim" "default")})

(def code-mirror-key-down
  [; eval 
   {:spec "enter"      :handler [:eval]       :scope :codemirror-no-context :key ::eval} ; :eval goes to buffer/notebook/eval
   ; buffer navigation
   {:spec "up"         :handler [:arrow-up]   :scope :codemirror :key ::up} ; [:move-up]
   {:spec "down"       :handler [:arrow-down] :scope :codemirror :key ::down} ; [:move-down]
   ; code completion
   {:spec "ctrl-space" :handler [:hint]       :scope :codemirror :desc "Show possible auto-completions." :key     ::hint}
   {:spec "tab"        :handler [:hint-next]  :scope :codemirror :key ::next}
   {:spec "shift-tab"  :handler [:hint-prior] :scope :codemirror :key ::prior}
   #_{:spec "ctrl"     :handler [:completion/show-all true] :scope :global :key     ::showallshow}
   ; test
   {:spec "t"          :handler [:eval]        :scope :codemirror-no-context :key ::test}
   ;
   ])

(def code-mirror-key-up
  [#_{:spec "enter"    :handler [:completion/clear]          :key ::clear}
   #_{:spec "ctrl"     :handler [:completion/show-all false] :scope :global :key ::show-all-hide}])



