(ns pinkgorilla.notebook-ui.codemirror-buffer.buffer
  (:require
   [taoensso.timbre :refer-macros [info errorf]]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub dispatch]]
   [cljs.reader]
   [cljs.tools.reader]
   [pinkgorilla.nrepl.op.eval :refer [nrepl-eval]]))

(def demo-notebook
  ; same format as hydrated notebook.
  {:segments {:scratchpad {:code "(+ 2 2)(println 2)" :result nil}
              :1 {:code "(+ 1 1)(println 1)\n {:a 5 :b \"ttt\"}" :result nil}
              :3 {:code "(+ 3 3)(println 3)" :result nil}}
   :order [:1
           :scratchpad
           :3]})

(reg-event-db
 :buffer/init
 (fn [db [_]]
   (let [db (or db {})]
     (assoc db
            :buffer demo-notebook))))

(reg-event-db
 :buffer/set-code
 (fn [db [_ buffer-id-kw code]]
   (assoc-in db [:buffer :segments buffer-id-kw :code] code)))

(reg-event-fx
 :buffer/eval
 (fn [{:keys [db] :as cofx} [_ buffer-id-kw]]
   (let [code (get-in db [:buffer :segments buffer-id-kw :code])]
     (if code
       (dispatch [:nrepl/op nrepl-eval [code] [:buffer :segments buffer-id-kw :result] false])
       (errorf "cannot eval buffer %s - code is nil!" buffer-id-kw)))))

(reg-event-db
 :buffer/set-result
 (fn [db [_ buffer-id-kw result]]
   (assoc-in db [:buffer :segments buffer-id-kw :result] result)))

(reg-sub
 :buffer/view
 (fn [db [_ buffer-id-kw]]
   (-> db
       (get-in [:buffer :segments buffer-id-kw])
       (assoc :id buffer-id-kw))))

(reg-sub
 :buffer/sort
 (fn [db [_]]
   (-> db
       (get-in [:buffer :order]))))

(reg-sub
 :buffer/notebook
 (fn [db [_]]
   (-> db
       (get-in [:buffer]))))

(defn move [sort current-buffer-id-kw direction]
  ;(info "sort: " sort)
  (let [v-indexed (map-indexed (fn [idx id] [idx id]) sort)
        ;_ (info "v-indexed: " v-indexed)
        current (first
                 (filter
                  (fn [[idx id]] (= current-buffer-id-kw id))
                  v-indexed))
        ;_ (info "current: " current)
        current-idx (get current 0)
        lookup (into {} v-indexed)
        ;_ (info "lookup: " lookup)
        idx-target (case direction
                     :down (min (+ current-idx 1) (- (count sort) 1))
                     :up (max 0 (- current-idx 1)))
        ;_ (info "idx-target: " idx-target)
        ]
    (get lookup idx-target)))










