(ns pinkgorilla.notebook-ui.notebook.codemirror
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.notebook-ui.codemirror.editor :refer [codemirror-reagent]]
   #_[pinkgorilla.notebook-ui.completion.component :refer [completion-component]]))

(defn codemirror-edit [cm-opts {:keys [id] :as eval-result}]
  (let [settings (subscribe [:settings])
        theme (or (:codemirror-theme @settings) "paraiso-dark")
        ;buffer (subscribe [:notebook/segment-active])
        options-notebook {:theme theme
                          :move-up #(dispatch [:notebook/move :up])
                          :move-down #(dispatch [:notebook/move :down])
                          :save (fn [code]
                                  (dispatch [:notebook/set-code id code]))
                          :eval #(dispatch [:notebook/eval])}]
    [:div.my-codemirror
     [codemirror-reagent eval-result (merge options-notebook cm-opts)]]))

(defn codemirror-edit-inline [{:keys [id] :as eval-result}]
  (let [_ (info "codemirror-inline is loading: " id)
        cm-opts {:width  "100%" ; "400px"
                 :font-size 20
                 :padding "2px"}]
    [:div

     [codemirror-edit cm-opts eval-result]]))

(defn codemirror-edit-fullscreen [{:keys [id] :as eval-result}]
  (let [_ (info "codemirror-full is loading: " id)
        cm-opts {:height  "100px" ; "100%" ; "auto" (auto=resize-to content) ; "200px"
                 :width  "100%" ; "400px"
                 :font-size 20
                 :padding "2px"}]
    [codemirror-edit cm-opts eval-result]))

