(ns pinkgorilla.notebook-ui.notebook.theme
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.notebook-ui.eval-result.code-viewer :refer [code-viewer-theme]]
   [pinkgorilla.notebook-ui.codemirror.theme :refer [theme-codemirror]]))

(defn theme-css [on-load]
  (let [settings (subscribe [:settings])
        code-editor (or (:code-editor @settings) :text)
        on-load-codemirror (fn [] (info "codemirror theme loaded!")
                             (when on-load
                               ;(on-load)
                               (js/setTimeout on-load 3000)))]

    [:div
     [code-viewer-theme]
     [theme-codemirror on-load-codemirror]
     #_(case code-editor
         :codemirror
         [:div] ; currently only codemirror has a theme
         )]))