(ns pinkgorilla.notebook-ui.codemirror.extension.buffer-sync
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [pinkgorilla.notebook-ui.codemirror.extension :refer [run-extension-no-context]]))

(defn move-to-last-line [cm]
  (let [last-line (.lastLine cm)
        last-ch (count (.getLine cm last-line))]
    (.setCursor cm last-line last-ch)))

; load/save from/to buffer

(defn get-data [{:keys [type code md]}]
  (case type
    :code code
    :md md
    code))

(defn load-code2 [cm eval-result]
  ;(info "load code: " eval-result)
  (let [editor-data (.getValue @cm)
        data (get-data eval-result)
        data (or data "")]
    (when-not (= data editor-data)
      (.setValue @cm data)
      ;(move-to-last-line @cm)
      )))

#_(defn load-code [{:keys [cm-opts cm buffer] :as context}]
    (let [editor-code (.getValue @cm)
          {:keys [code]} @buffer]
      (when-not (= code editor-code)
        (.setValue @cm code)
        (move-to-last-line @cm))))

(defn save-code [{:keys [cm-opts cm buffer] :as context}]
  (let [editor-code (.getValue @cm)
        data (get-data @buffer)
        type (:type @buffer)
        ;{:keys [code]} @buffer
        ]
    (when-not (= data editor-code)
      (run-extension-no-context context [:save editor-code type]))))

