(ns pinkgorilla.notebook-ui.codemirror.editor
  (:require
   [taoensso.timbre :refer-macros [debug info warn]]
   [reagent.core :as r]
   [reagent.dom :as rd]
   [re-frame.core :refer [dispatch subscribe]]
   ["codemirror" :as CodeMirror]
   ["codemirror/addon/edit/closebrackets"]
   ["codemirror/addon/edit/matchbrackets"]
   ["codemirror/addon/hint/show-hint"]
   ["codemirror/addon/runmode/runmode"]
   ["codemirror/addon/runmode/colorize"]
   ["codemirror/mode/clojure/clojure"]
   ["codemirror/mode/markdown/markdown"]
   ; [cljsjs.codemirror.mode.xml]
   ; [cljsjs.codemirror.mode.javascript]
   ; ["parinfer-codemirror"]
   ; [cljsjs.codemirror.mode.clojure-parinfer]
   ;["codemirror/keymap/vim"]
   [pinkgorilla.notebook-ui.codemirror.theme]
   [pinkgorilla.notebook-ui.codemirror.highlight]
   [pinkgorilla.notebook-ui.codemirror.extension.buffer-sync :refer [load-code2 get-data]]
   [pinkgorilla.notebook-ui.codemirror.key-binding :refer [on-key-down on-key-up]]
   [pinkgorilla.notebook-ui.codemirror.options :refer [cm-default-opts]]
   [pinkgorilla.notebook-ui.codemirror.extension :refer [run-extension]]
   [pinkgorilla.notebook-ui.codemirror.extensions :refer [cm-fun]]))

(defn on-mousedown [eval-result cm evt]
  (debug "on-mousedown")
  (dispatch [:notebook/move :to (:id eval-result)])
  (dispatch [:notebook/set-edit? true]))

(defn focus-cm!
  [cm]
  (when cm
    (.focus cm)))

(defn destroy-editor [cm-a]
  (if @cm-a
    (do (.toTextArea @cm-a)
        (reset! cm-a nil))
    (warn "Could not kill CodeMirror instance")))

(defn codemirror-reagent
  "code-mirror editor"
  [eval-result cm-opts]
  (let [opts  (merge
               cm-fun
               cm-default-opts
               cm-opts)
        cm (atom nil)
        run (fn [handler]
              (run-extension {:cm-opts opts :cm cm} handler))]
    (r/create-class
     {:component-did-mount
      (fn [this]
        (let [el (rd/dom-node this)
              opts-js (clj->js opts)
              ;_ (info "component-did-mount: cm")
              ;cm_ (CodeMirror. el opts-js)
              cm_ (.fromTextArea CodeMirror el opts-js)
              code (get-data eval-result)]
          (reset! cm cm_)

          (info "component-did-mount: cm code : " code)
          (.setValue cm_ code)

          ; theme - already set in cm constructor
          ;(.setOption inst "theme" (:theme opts))

          (.on cm_ "change" (fn [] (run [:save-code])))
   ;       (.on cm_ "keydown"  (partial on-key-down opts))
          ; (.on inst "keyup"  on-key-up)         

          (.on cm_ "mousedown" (partial on-mousedown eval-result))

          ;(when on-cm-init (on-cm-init inst))
          ;(focus-cm! inst)
          ))

      :component-will-unmount
      (fn [this]
        (info "cm component-will-unmount")
        (destroy-editor cm))

      :component-did-update
      (fn [this old-argv]
        (let [[_ buffer _] (r/argv this)]
          ;(info "component-did-update: current buffer: " buffer)
          (load-code2 cm buffer)
          #_(run [:load-code])))

      :reagent-render
      (fn []
        (let [{:keys [readOnly]} opts]
          ;(info "read-only?: " readOnly)
          (if readOnly
            [:textarea {:read-only true}]
            [:textarea])))})))



