(defproject org.pinkgorilla/notebook-ui "0.0.71"
  :description "Reagent components for notebook ui."
  :url "https://github.com/pink-gorilla/notebook-ui"
  :license {:name "MIT"}
  :deploy-repositories [["releases" {:url "https://clojars.org/repo"
                                     :username :env/release_username
                                     :password :env/release_password
                                     :sign-releases false}]]

  :prep-tasks ["css"] ; copies codemirror theme-css, so they end up as resources

  :release-tasks [["vcs" "assert-committed"]
                  ["bump-version" "release"]
                  ["vcs" "commit" "Release %s"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy"]
                  ["bump-version"]
                  ["vcs" "commit" "Begin %s"]
                  ["vcs" "push"]]

  :source-paths ["src"]
  :test-paths ["test"]

  :target-path  "target/jar"
  :clean-targets ^{:protect false} [:target-path
                                    [:demo :builds :app :compiler :output-dir]
                                    [:demo :builds :app :compiler :output-to]]

  :resource-paths  ["resources" ; notebook-ui resources (css)
                    "target/node_modules"] ; css png resources from npm modules (codemirror themes)

  :managed-dependencies [; to avoid a :exclusion mess, we define certain versions numbers centrally
                         [nrepl "0.8.0"]
                         
                         ; clojure
                         [org.clojure/clojure "1.10.1"]
                         [org.clojure/core.async "1.3.610"]
                         [org.clojure/clojurescript "1.10.773"]
                         [org.clojure/tools.analyzer "1.0.0"]
                         [com.google.javascript/closure-compiler-unshaded "v20200719"]
                         [com.google.code.findbugs/jsr305 "3.0.2"]
                         [org.clojure/tools.logging "1.1.0"]
                         [org.jboss.logging/jboss-logging "3.4.1.Final"]

                         ; serialization libraries are dependencies of many libraries,
                         [org.clojure/core.memoize "1.0.236"]
                         [org.clojure/data.json "1.0.0"]
                         [org.clojure/data.fressian "1.0.0"]
                         [org.clojure/data.xml "0.0.8"]
                         [org.clojure/data.csv "1.0.0"]
                         [org.clojure/core.match "1.0.0"]
                         [com.cognitect/transit-clj "1.0.324"]
                         [com.cognitect/transit-cljs "0.8.264"]
                         [com.cognitect/transit-java "1.0.343"]

                         [com.fasterxml.jackson.core/jackson-core "2.11.2"]
                         [com.fasterxml.jackson.dataformat/jackson-dataformat-cbor "2.11.2"]
                         [com.fasterxml.jackson.dataformat/jackson-dataformat-smile "2.11.2"]

                         [org.apache.httpcomponents/httpasyncclient "4.1.4"]
                         [org.apache.httpcomponents/httpcore "4.4.13"]

                         [org.clojure/tools.cli "1.0.194"]
                         [org.apache.httpcomponents/httpclient "4.5.12"]

                         [cheshire "5.10.0"]
                         [com.taoensso/encore "2.122.0"]
                         ; patches to get most uptodate version for certain conflicts:
                         [commons-codec "1.14"] ; selmer and clj-http (via gorilla-explore)
                         [ring/ring-codec "1.1.2"] ; ring and compojure
                         [org.flatland/useful "0.11.6"] ; clojail and ring-middleware-format

                         [tigris "0.1.2"]]

  :dependencies [[org.pinkgorilla/webly "0.0.23"]
                 [org.clojure/clojure "1.10.1"]
                 [org.clojure/core.async "1.3.610"]
                 ; notebook-ui is a cljs project, so in here are cljs dependencies
                 [thi.ng/strf "0.2.2"]
                 [com.taoensso/timbre "4.10.0"] ; clojurescript logging awb99: this fucks up kernel-cljs-shadowdeps
                 [com.lucasbradstreet/cljs-uuid-utils "1.0.2"] ;; awb99: in encoding, and clj/cljs proof
                 [day8.re-frame/http-fx "0.2.1"  ; reframe based http requests
                  :exclusions [[re-frame]]] ; a more modern reframe comes from webly
                 [day8.re-frame/undo "0.3.3"]
                 [day8.re-frame/tracing "0.6.0"]
                 [keybind "2.2.0"]
                 [re-com "2.8.0"]
                 [org.pinkgorilla/nrepl-middleware "0.3.11"] ; brings picasso
                 [org.pinkgorilla/gorilla-ui "0.2.28" ; brings pinkie
                  :exclusions [org.clojure/clojurescript]]
                 [org.pinkgorilla/gorilla-explore "0.2.33"] ; brings notebook-encoding + gorilla-ui
                 ]

  :profiles {:test {:source-paths ["src" "test"]
                    :test-paths   ["test"]}

             :demo {:source-paths ["src"
                                   "profiles/demo/src"
                                   "test"]
                    :resource-paths ["target/webly" ; bundle
                                     ]}

             :dev  {:dependencies [[clj-kondo "2020.07.29"]]
                    :plugins      [[lein-cljfmt "0.6.6"]
                                   [lein-cloverage "1.1.2"]
                                   [lein-ancient "0.6.15"]
                                   [lein-resource "17.06.1"]
                                   [lein-shell "0.5.0"]]
                    :aliases      {"clj-kondo"
                                   ["run" "-m" "clj-kondo.main"]

                                   "bump-version" ^{:doc "Increases project.clj version number (used by CI)."}
                                   ["change" "version" "leiningen.release/bump-version"]}
                    :cloverage    {:codecov? false ; https://github.com/codecov/example-clojure
                                  ;; In case we want to exclude stuff
                                  ;; :ns-exclude-regex [#".*util.instrument"]
                                  ;; :test-ns-regex [#"^((?!debug-integration-test).)*$$"]
                                   }
                   ;; TODO : Make cljfmt really nice : https://devhub.io/repos/bbatsov-cljfmt
                    :cljfmt       {:indents {as->                [[:inner 0]]
                                             with-debug-bindings [[:inner 0]]
                                             merge-meta          [[:inner 0]]
                                             try-if-let          [[:block 1]]}}}}

  :aliases {"clean"  ^{:doc "Cleans build artefacts."}
            ["shell" "./scripts/clean.sh"]
            "css"  ^{:doc "Copies certain npm package dependecies"}
            ["shell" "./scripts/copy_res.sh"]

            ;; test

            "build-test"  ^{:doc "Builds Bundle. Gets executed automatically before unit tests."}
            ["with-profile" "+test" "run" "-m" "shadow.cljs.devtools.cli" "compile" "ci"]

            "test-run" ^{:doc "Runs unit tests. Does not build the bundle first.."}
            ["shell" "./node_modules/karma/bin/karma" "start" "--single-run"]

            ; "test-js" ^{:doc "Test compiled JavaScript."}
            ; ["shell" "npm" "run" "test"]
            "test-js" ^{:doc "Run Unit Tests. Will compile bundle first."}
            ["do" "build-test" ["test-run"]]

            ;; SHADOW (for testing only)

            "build-shadow-ci" ["run" "-m" "shadow.cljs.devtools.cli" "compile" ":demo"] ; :ci
            ;"shadow-watch-demo" ["run" "-m" "shadow.cljs.devtools.cli" "watch" ":demo"]

            ;"demo"  ^{:doc "Runs UI components via webserver."}
            ;["with-profile" "+demo" "run" "-m" "shadow.cljs.devtools.cli" "watch" "watch" "demo"]

            ;; APP

            "build-dev"  ^{:doc "compiles bundle via webly"}
            ["with-profile" "+demo" "run" "-m" "webly.build-cli" "compile" "+dev" "demo.app/handler" "demo.app"]

            "build-prod"  ^{:doc "compiles bundle via webly"}
            ["with-profile" "+demo" "run" "-m" "webly.build-cli" "release" "+demo" "demo.app/handler" "demo.app"]

            "run-web"  ^{:doc "runs compiles bundle on shadow dev server"}
            ["with-profile" "+demo" "run" "-m" "demo.app" "run"]

            "demo"  ^{:doc "Runs UI components via webserver."}
            ["with-profile" "+demo" "run" "-m" "demo.app" "watch"]})
