(ns pinkgorilla.notebook-ui.notebook.notebook
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [reagent.core :as r]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.notebook-ui.notebook.theme :refer [theme-css]]
   [pinkgorilla.notebook-ui.notebook.segment :refer [segment-view]]))

; use from encoding / hydration

(defn segments-ordered [notebook]
  (let [segments (:segments notebook)
        segment-ids-ordered (:order notebook)]
    (vec (map #(get segments %) segment-ids-ordered))))

(defn code? [segment]
  (= :code (:type segment)))

(defn notebook-viewer [storage notebook]
  (let [settings (subscribe [:settings])
        segment-active (subscribe [:notebook/segment-active])
        theme-css-loaded (r/atom false)
        on-css-loaded (fn []
                        ;(info "notebook viewer css ready!")
                        (reset! theme-css-loaded true))]
    (dispatch [:notebook/activate! storage])
    (when-not (:active notebook)
      (dispatch [:notebook/move :last]))
    (fn [storage notebook]
      (let [layout (or (:layout @settings) :vertical)
            segments (segments-ordered notebook)
            ;_ (info "nb segments: " segments)
            ]
        [:div.w-full.h-full.min-h-full.bg-gray-100 ; .overflow-scroll
         [theme-css on-css-loaded]
         (if @theme-css-loaded
           (if (= layout :single)
             [:div.h-full.min-h-full
              [segment-view @segment-active]]
             [:div (for [s segments]
                     ^{:key (:id s)}
                     [segment-view s])])
           [:h1 "codemirror theme loading .."])]))))

