(ns pinkgorilla.notebook-ui.notebook.codemirror
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.notebook-ui.codemirror.editor :refer [codemirror-reagent]]
   #_[pinkgorilla.notebook-ui.completion.component :refer [completion-component]]))

(defn save-segment  [id code type]
  (info "saving " id "code: " code)
  (case type
    :md (dispatch [:notebook/set-md id code])
    :code (dispatch [:notebook/set-code id code])
    (dispatch [:notebook/set-code id code])))

(defn codemirror-edit [{:keys [id] :as eval-result} {:keys [active? edit?]}]
  (let [settings (subscribe [:settings])]
    (fn [{:keys [id code] :as eval-result} {:keys [active? edit?]}]
      (let [theme (or (:codemirror-theme @settings) "paraiso-dark")
            readOnly (not (and active? edit?))
            #__ #_(info "id:" id
                        "active:" active?
                        "edit?:" edit?
                        "readOnly:" readOnly)
            options-notebook {:active? active?
                              :edit? edit?
                              ;:readOnly readOnly
                              :theme theme
                              :move-up #(dispatch [:notebook/move :up])
                              :move-down #(dispatch [:notebook/move :down])
                              :save save-segment
                              :eval #(dispatch [:notebook/eval])}]
        ;(info "render codemirror-edit " id code)
        [:div.my-codemirror
         [codemirror-reagent eval-result options-notebook]]))))



