(ns pinkgorilla.notebook-ui.nrepl.info
  (:require-macros
   [reagent.ratom :refer [reaction]])
  (:require
   [taoensso.timbre :refer-macros [info]]
   [re-frame.core :refer [reg-sub reg-sub-raw subscribe dispatch]]
   [webly.web.handler :refer [reagent-page]]
   [pinkgorilla.notebook-ui.nrepl.view :refer [session-panel desc-panel]]
   [pinkgorilla.notebook-ui.nrepl.connect-ui :refer [connect-ui]]))

(reg-sub
 :nrepl/info
 (fn [db _]
   (get-in db [:nrepl :info])))

(reg-sub
 :nrepl/connected?
 (fn [db _]
   (get-in db [:nrepl :connected?])))

(defn get-info
  [db event]
  (reaction
   (let [ninfo (subscribe [:nrepl/info])
         connected? @(subscribe [:nrepl/connected?])]   ;; <-- subscribe used here
     (if connected?
       (do
         (info "info component requesting describe on nrepl connect")
         (dispatch [:nrepl/describe])
         (dispatch [:nrepl/ls-sessions])
         (dispatch [:nrepl/eval :test-kernel "(+ 1 1)"]))

       (info "info component: not connected "))
     @ninfo)))

(reg-sub-raw
 :nrepl/info-active
 get-info)

(defn nrepl-info []
  (let [ninfo (subscribe [:nrepl/info-active])]
    (fn []
      (let [i @ninfo
            {:keys [describe sessions]} i
            _ (info "nrepl-info: "  describe)]
        [:div
         [connect-ui]
         [desc-panel describe]
         (when sessions
           [session-panel sessions])]))))

(defmethod reagent-page :ui/nrepl [& args]
  [nrepl-info])