(ns pinkgorilla.notebook-ui.codemirror.eval
  (:require
   [taoensso.timbre :refer-macros [info]]
   [reagent.core :as r]
   [re-frame.core :refer [dispatch dispatch-sync subscribe]]
   [cljs.reader]
   [cljs.tools.reader]
   [pinkgorilla.notebook-ui.codemirror.options :refer [settings]]))

(defn is-valid-cljs? [source]
  (try
    (do
      (cljs.tools.reader/read-string source)
      true)
    (catch js/Error _
      false)))

(defn should-eval [inst evt source]
  (let [lines (.lineCount inst)
        in-place (or (= 1 lines)
                     (let [pos (.getCursor inst)
                           last-line (dec lines)]
                       (and
                        (= last-line (.-line pos))
                        (= (.-ch pos)
                           (count (.getLine inst last-line))))))]
    (and in-place
         (is-valid-cljs? source))))

(defn run-eval [text]
; {:warning-as-error (:warning-as-error @settings)}
  (info "code-mirror eval: " text))



