(ns pinkgorilla.notebook-ui.kernel.info-component
  (:require-macros
   [cljs.core.async.macros :refer [go go-loop]]
   [reagent.ratom :refer [reaction]])
  (:require
   [taoensso.timbre :refer-macros (info)]
   [cljs.core.async :as async :refer [<! >! chan timeout close!]]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [pinkgorilla.nrepl.op.admin :refer [describe ls-sessions]]

   [pinkgorilla.notebook-ui.kernel.info-view :refer [session-panel desc-panel]]
   [pinkgorilla.nrepl.op.cider :refer [stacktrace resolve-symbol doc-string completions]]))

(reg-sub
 :nrepl/info
 (fn [db _]
   (get-in db [:nrepl :info])))

(reg-sub
 :nrepl/connected?
 (fn [db _]
   (get-in db [:nrepl :connected?])))

(defn get-info
  [db event]
  (reaction
   (let [ninfo (subscribe [:nrepl/info])
         connected? @(subscribe [:nrepl/connected?])]   ;; <-- subscribe used here
     (if connected?
       (do
         (info "info component requesting describe on nrepl connect")
         (dispatch [:nrepl/describe])
         (dispatch [:nrepl/ls-sessions])
         (dispatch [:nrepl/eval :test "(+ 1 1)"]))

       (info "info component: not connected "))
     @ninfo)))

(reg-sub-raw
 :nrepl/info-active
 get-info)

(defn nrepl-info []
  (let [ninfo (subscribe [:nrepl/info-active])]
    (fn []
      (let [i @ninfo
            _ (info "nrepl-info: "  i (:describe i))
            d (:describe i)
            ls (:sessions i)]
        [:div
         [:h1 "nrepl ws connection:"]
         [desc-panel d]
         (when ls
           [session-panel ls])]))))