(ns pinkgorilla.notebook-ui.app.events
  (:require
   [taoensso.timbre :as timbre :refer [info]]
   [re-frame.core :refer [reg-event-db dispatch]]
   [pinkgorilla.ui.config :refer [set-prefix!]]
   [pinkgorilla.notebook-ui.hydration :refer [hydrate dehydrate]]))

(reg-event-db
 :notebook-ui/start
 (fn [db [_]]
   (let [{:keys [nrepl-endpoint]} (:config db)]
     (info "notebook-ui-demo starting ..")
     (dispatch [:ga/event {:category "notebook-ui" :action "started" :label 77 :value 13}])

     ; from gorilla-ui
     (set-prefix! "/r/")

     ; from explorer
     (dispatch [:explorer/init  {:fn-hydrate hydrate
                                 :fn-dehydrate dehydrate}])

     ; from notebook-ui
     (dispatch [:nrepl/init nrepl-endpoint])
     (dispatch [:sniffer/init]) ; hack so sniffer notebook route works at startup.
     (dispatch [:notebook/init])
     (dispatch [:punk/init])
     (dispatch [:completion/init])
     (dispatch [:codemirror/init])
;     (dispatch [:schema/check-on])
     (dispatch [:webly/status :running])

     db)))


