(ns pinkgorilla.notebook-ui.codemirror.cm-events.sync
  (:require
   [taoensso.timbre :refer-macros [debugf info error]]
   [re-frame.core :refer [dispatch]]))

(defn move-to-last-line [cm]
  (let [last-line (.lastLine cm)
        last-ch (count (.getLine cm last-line))]
    (.setCursor cm last-line last-ch)))

; load/save from/to buffer

(defn get-data [{:keys [type code md]}]
  (case type
    :code code
    :md md
    code))

(defn load-code [cm eval-result]
  ;(info "load code: " eval-result)
  (let [editor-data (.getValue cm)
        data (get-data eval-result)
        data (or data "")]
    (when-not (= data editor-data)
      (.setValue cm data)
      ;(move-to-last-line @cm)
      )))

(defn save-segment  [id code type]
  (case type
    :md (dispatch [:segment/set-md id code])
    :code (dispatch [:segment/set-code id code])
    (dispatch [:segment/set-code id code])))

(defn on-change [{:keys [cm-opts cm eval-result] :as context} s evt]
  (when eval-result ; in single layout sometimes save on nil buffer happens
    (let [editor-code (.getValue cm)
          data (get-data eval-result)
          type (:type eval-result)]
      (when-not (= data editor-code)
        (debugf "saving cm stext to reframe segment: %s" (:id eval-result))
        (save-segment (:id eval-result) editor-code type)))))

