(ns pinkgorilla.notebook-ui.codemirror.cm-js.arrow-nav
  (:require
   [taoensso.timbre :refer-macros [debug info error]]
   [re-frame.core :refer [dispatch]]))

; navigate buffer up/down

(defn first-line-number [cm]
  (.firstLine cm))

(defn last-line-number [cm]
  (.lastLine cm))

(defn current-line-number [cm]
  (let [pos (.getCursor cm)]
    (.-line pos)))

(defn first-line? [cm]
  (let [f (first-line-number cm)
        c (current-line-number cm)]
    (info "first line: " f " current-line:" c)
    (= f c)))

(defn last-line? [cm]
  (let [l (last-line-number cm)
        c (current-line-number cm)]
    (info "last line: " l " current-line:" c)
    (= l c)))

(defn arrow-up [{:keys [cm] :as context} e]
  (info "arrow-up context: " context)
  (when (first-line? cm)
    (info "first-line")
    (.preventDefault e)
    (dispatch [:notebook/move :up])))

(defn arrow-down [{:keys [cm] :as context} e]
  (info "down.")
  (when (last-line? cm)
    (info "last-line!!")
    (.preventDefault e)
    (dispatch [:notebook/move :down])))

