(ns pinkgorilla.notebook-ui.codemirror.events.core
  (:require
   [cljs.reader]
   [cljs.tools.reader]
   [re-frame.core :refer [reg-event-db reg-event-fx dispatch]]
   [pinkgorilla.ui.config :refer [#_link-css res-href]]
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [pinkgorilla.notebook-ui.codemirror.codemirror :refer [configure-cm-globally!]]))

(reg-event-fx
 :codemirror/init
 (fn [_ _]
   (dispatch [:codemirror/load-theme])
   (configure-cm-globally!)))

(reg-event-db
 :codemirror/set-active
 (fn [db [_ segment-id cm]]
   (assoc-in db [:codemirror] {:id segment-id
                               :cm cm})))

