(ns pinkgorilla.notebook-ui.codemirror.theme
  (:require
   [re-frame.core :refer [subscribe]]
   [taoensso.timbre :as timbre :refer [debug info warn error]]))

(def theme-names
  ["default" "3024-day" "3024-night" "abcdef" "ambiance" "ayu-dark" "ayu-mirage"
   "base16-dark" "base16-light" "bespin" "blackboard" "cobalt" "colorforth"
   "darcula" "dracula" "duotone-dark" "duotone-light" "eclipse" "elegant"
   "erlang-dark" "gruvbox-dark" "hopscotch" "icecoder" "idea" "isotope"
   "lesser-dark" "liquibyte" "lucario" "material" "material-darker"
   "material-palenight" "material-ocean" "mbo" "mdn-like" "midnight" "monokai"
   "moxer" "neat" "neo" "night" "nord" "oceanic-next" "panda-syntax"
   "paraiso-dark" "paraiso-light" "pastel-on-dark" "railscasts" "rubyblue"
   "seti" "shadowfox" "solarized dark" "solarized light" "the-matrix"
   "tomorrow-night-bright" "tomorrow-night-eighties" "ttcn" "twilight"
   "vibrant-ink" "xq-dark" "xq-light" "yeti" "yonce" "zenburn"])

(def themes (->> theme-names (mapv vector (map keyword theme-names)) (into {})))

; var link = document.createElement ('link');
;link.rel  = 'stylesheet';
;link.href = cssURL;
;document.head.appendChild (link);

;var head  = document.getElementsByTagName('head')[0];
;    var link  = document.createElement('link');
;    link.id   = cssId;
;    link.rel  = 'stylesheet';
;    link.type = 'text/css';
;    link.href = 'http://website.com/css/stylesheet.css';
;    link.media = 'all';
;    head.appendChild(link);


(defn add-theme-css [theme-name]
  (let [href (str "/r/codemirror/theme/" theme-name ".css")
        _ (println "adding: " href)
        head (.-head js/document)
        href (clj->js href)
        link (.createElement js/document "link")]
    (.setAttribute link "href" href)
    (.setAttribute link "rel" "stylesheet")
    (.setAttribute link "type" "text/css")
    (println "link: " href)
    (.appendChild head link)))

;(add-theme-css "paraiso-dark")

;; CSS LINKS for setting

(def link-codemirror-css
  "codemirror/lib/codemirror.css")

(defn link-codemirror-theme   [{:keys [codemirror-theme]
                                :or {codemirror-theme "paraiso-dark"}
                                :as settings}]
  (when-not (= codemirror-theme "default")
    (str "codemirror/theme/" codemirror-theme ".css")))

(defn codemirror-css-urls-for-settings [settings]
  (let [theme-link (link-codemirror-theme settings)]
    (if theme-link
      [link-codemirror-css
       theme-link]
      [link-codemirror-css])))

;; styles for theme

(defn style-codemirror-inline []
  ; Set height, width, borders, and global font properties here
  ; height: 200px;
  ; height: auto;    auto = adjust height to fit content 
  ; height: 100%
  [:style ".my-codemirror > .CodeMirror { 
              font-family: monospace;
              height: auto;
            }"])

(defn style-codemirror-fullscreen []
  ; height: auto; "400px" "100%"  height: auto;
  [:style ".my-codemirror > .CodeMirror { 
              font-family: monospace;
              height: 100% ;
            }"])

#_(defn styles-codemirror-for-setttings [layout]
    [:div
     (if (= layout :single)
       style-codemirror-fullscreen
       style-codemirror-inline)])

