(ns pinkgorilla.notebook-ui.kernel.events-sniffer
  (:require
   [taoensso.timbre :as timbre :refer-macros [info errorf debug warn error]]
   [cljs.reader]
   [cljs.tools.reader]
   [re-frame.core :refer [reg-event-db reg-event-fx dispatch]]
   [pinkgorilla.nrepl.client.op.eval :refer [process-fragment initial-value]]
   [pinkgorilla.storage.unsaved :refer [StorageUnsaved]]
   [pinkgorilla.notebook.template :refer [snippets->notebook]]
   [pinkgorilla.notebook-ui.hydration  :refer [hydrate create-code-segment insert-segment-bottom]]))

(def id-doc-sniffer "sniffer-notebook")

(reg-event-db
 :sniffer/create-document
 (fn [db [_ snippets]]
   (let [snippets (or snippets ["; sniffed evals:"])
         storage (StorageUnsaved. id-doc-sniffer)
         document-dehydrated (snippets->notebook snippets)
         document (hydrate document-dehydrated)
         db-new (assoc-in db [:document :documents storage] document)]
     (dispatch [:notebook/activate! storage])
     db-new)))

(reg-event-fx
 :sniffer/init
 (fn [{:keys [db] :as cofx} [_]]
   (dispatch [:sniffer/create-document])))

(defn add-code-segment [notebook msg]
  (let [{:keys [code id]} msg
        id-kw (keyword id)
        _ (debug "sniffed code id: " id-kw " code:" code)
        segment-new (create-code-segment code)
        segment-new (assoc segment-new :id id-kw)
        segment-new (merge segment-new initial-value)]
    (insert-segment-bottom notebook segment-new)))

(defn add-result [notebook msg]
  (debug "sniffed result: " msg)
  (let [{:keys [id]} msg
        seg-id (keyword id)
        segment (get-in notebook [:segments seg-id])
        result-new (process-fragment segment msg)
        segment-new (merge segment result-new)]
    (assoc-in notebook [:segments seg-id] segment-new)))

(reg-event-db
 :sniffer/rcvd
 (fn [db [_ msg]]
   (let [storage (StorageUnsaved. id-doc-sniffer)
         notebook (get-in db [:document :documents storage])]
     (cond
       (= "eval" (:op msg))
       (assoc-in db [:document :documents storage] (add-code-segment notebook msg))

       :else
       (do  (assoc-in db [:document :documents storage] (add-result notebook msg))
           ;db
            )))))


