(ns pinkgorilla.notebook-ui.app.pages.explorer
  (:require
   [taoensso.timbre :as timbre :refer [info]]
   [re-frame.core :refer [dispatch subscribe]]
   [webly.web.handler :refer [reagent-page]]
   [webly.web.routes :refer [query-params]]
   [pinkgorilla.explore.component :refer [notebook-explorer]]
   [pinkgorilla.document.component :refer [document-page]]
   [pinkgorilla.explorer.bidi :refer [goto-notebook!]]
   [pinkgorilla.notebook-ui.views.notebook :refer [notebook-storage-viewer]]))

(defn header-icon [fa-icon rf-dispatch]
  [:a {:on-click #(dispatch rf-dispatch)
       :class "hover:text-blue-700 mr-1"}
   [:i {:class (str "fa-lg pl-1 " fa-icon)}]])

;; NOTEBOOK

(defn nrepl-icon []
  (let [connected? (subscribe [:nrepl/connected?])]
    (fn []
      (if @connected?
        [:span.text-green-500 [header-icon "fas fa-circle"  [:bidi/goto :ui/nrepl]]]
        [:span.text-red-500 [header-icon "fas fa-circle" [:bidi/goto :ui/nrepl]]]))))

(defn header-menu-left [storage document]
  [:<>
   ;[header-icon "fa-question-circle" [:bidi/goto :demo/main]]
   [header-icon "fa fa-question-circle" [:bidi/goto :notebook/about]]
   [header-icon "fa fa-th-large" [:bidi/goto :ui/explorer]]
   [header-icon "fa fa-plus" [:document/new]]
   [header-icon "far fa-calendar" [:notebook/clear-all]]
   [header-icon "fa fa-microchip" [:notebook/evaluate-all]]
   [header-icon "fa fa-save" [:document/save storage]]
   [header-icon "fa fa-stream" [:palette/show]]
   [nrepl-icon]])

(defn document-viewer [storage document]
  [:div.bg-blue-300.h-full.min-h-full.w-full  ;:div.m-3.bg-blue-300
   [:link {:rel "stylesheet" :href "/r/codemirror/lib/codemirror.css"}]
   [:link {:rel "stylesheet" :href "/r/notebook-ui/datatypes.css"}]
   ;[:a {:on-click #(goto! :ui/explorer)} "explorer"]
   [notebook-storage-viewer storage @document]])

(defmethod reagent-page :ui/notebook [& args]
  [document-page document-viewer header-menu-left @query-params])

;; EXPLORER

(defn open-notebook [nb]
  (info "load-notebook-click" nb)
  (goto-notebook! (:storage nb)))

(defmethod reagent-page :ui/explorer [& args]
  [notebook-explorer open-notebook])
