(ns pinkgorilla.notebook-ui.app.pages.about
  (:require
   [re-frame.core :refer [dispatch]]
   [webly.web.handler :refer [reagent-page]]
   [webly.web.routes :refer [goto!]]))

(defn credit [user txt]
  [:li
   [:span
    [:a.w-16 {:href (str "https://github.com/" user)} user]
    [:span.ml-5 txt]]])

(defn action [{:keys [on-click href]} text]
  [:div.w-48.h-24.p-5.border-2.border-solid.border-gray-500.rounded.text-center.text-lg.cursor-pointer.bg-pink-100.hover:bg-pink-400
   {:on-click on-click
    :href href}
   (if href
     [:a {:href href} text]
     text)])

(defn notebook-about []
  [:div.container.mx-auto.gorilla-markdown
   [:h1.mt-5.text-2xl.italic "Welcome to" [:span.pl-5.text-pink-800.text-3xl.non-italic "PinkGorilla Notebook"]]

   ; Action
   [:div.mt-5
    [:div.flex.flex-column.justify-evenly
     [action {:on-click #(goto! :ui/explorer)} "Explorer"]
     [action {:on-click #(dispatch [:document/new])} "New Notebook"]
     [action {:on-click #(dispatch [:bidi/goto :ui/nrepl])} "nrepl"]
     [action {:on-click #(dispatch [:bidi/goto :ui/viz])} "gorilla ui"]
     [action {:on-click #(dispatch [:bidi/goto :ui/markdown :file "webly.md"])} "docs"]
     [action {:href "https://clojurians.zulipchat.com/#narrow/stream/212578-pink-gorilla-dev"} "Zulip Chat"]
     [action {:href "https://github.com/pink-gorilla/gorilla-notebook/issues"} "Ticket"]]]

   ; Features


   [:div.flex
    [:div.bg-yellow-300.mt-5.p-5
     [:h1.text-2xl "Features"]
     [:div.prose
      [:ul.list-disc
       [:li "Notebook with clj kernel"]
       [:li "Many visualization components"]]]]

    [:div.bg-yellow-300.mt-5.p-5
     [:h1.text-2xl "Keybindings"]
     [:p "shift enter - eval current cell"]
     [:p "alt-g k - keybinding dialog"]
     [:p "alt-g e - explorer window"]
     ;[:p "alt-g m - main window"]
     ;[:p "alt-g d - docs window"]
     ;[:p "alt-g n - notebook window"]
     [:p "alt-g r - repl info window"]]

     ; eval-sniffer
    [:div.bg-yellow-300.mt-5.p-5
     [:h1.text-2xl "Eval Sniffer"]
     [:div.prose
      [:ul.list-discs
       [:li "Work in your favorite ide, and build a notebook with gorilla visualisations."]
       [:li "Eval :gorilla/on in the repl"]
       [:li "A new notebook appears in /explorer (in unsaved)"]
       [:li "In /nrepl/info you can see the sessions that are currentl being sniffed."]
       [:li "To stop sniffing eval :gorilla/off in the repl"]]]]

     ;


    [:div.bg-green-300.mt-5.p-5
     [:h1.text-2xl "Credits"]
     [:div.prose
      [:ul.list-disc
       [credit "JonyEpsilon" "legacy gorilla-repl (with js frontend)"]
       [credit "deas" "port to re-frame, nrepl-relay, build-automation, unit-tests"]
       [credit "awb99" "gorilla-ui, goldly"]
       [credit "mauricioszabo" "goldly sci compiler, nrepl-tooling"]
       [credit "daslu" "notworking and testing, clojisr"]]]]]])

(defmethod reagent-page :notebook/about [{:keys [route-params query-params handler] :as route}]
  [notebook-about])