(ns pinkgorilla.notebook-ui.app.events
  (:require
   [taoensso.timbre :as timbre :refer [info]]
   [re-frame.core :refer [reg-event-db dispatch]]
   [pinkgorilla.notebook-ui.hydration :refer [hydrate dehydrate]]
   [example.example :refer [examples]]))

(reg-event-db
 :webly/before-load
 (fn [db [_]]
   (info "gorilla-notebook reload..")
   (reset! examples {})
   db))

(reg-event-db
 :notebook/start
 (fn [db [_]]
   (dispatch [:ga/event {:category "notebook" :action "started" :label 77 :value 13}])
   (dispatch [:notebook/init [:webly/status :running]])
   db))

(reg-event-db
 :notebook/init
 (fn [db [_ dispatch-init-done]]
   (let [db (or db {})
         {:keys [nrepl-endpoint]} (:config db)]
     (info "notebook-ui/init")

     ; from gorilla-ui
     ;(set-prefix! "/r/")

     ; from explorer
     (dispatch [:explorer/init  {:fn-hydrate hydrate
                                 :fn-dehydrate dehydrate}])

     ; from notebook-ui
     (dispatch [:nrepl/init nrepl-endpoint])
     ;(dispatch [:sniffer/init]) ; hack so sniffer notebook route works at startup.
     (dispatch [:punk/init])
     (dispatch [:completion/init])
     (dispatch [:codemirror/init])
;     (dispatch [:schema/check-on])
     (when dispatch-init-done
       (dispatch dispatch-init-done))

     (-> db
         (assoc-in [:notebook] nil)))))


