(ns pinkgorilla.notebook-ui.app.app
  (:require
   [taoensso.timbre :refer [info]]
   [webly.config :refer [load-config! get-in-config]]
   [webly.profile :refer [server?]]
   [webly.user.app.app :refer [webly-run!]]
   [pinkgorilla.explore.handler :refer [explore-directories-start]]
   [goldly.app :refer [goldly-run!]]
    ; side effects
   [pinkgorilla.notebook-ui.default-config]
   [pinkgorilla.notebook-ui.app.routes]))

(defn -main
  [profile-name]
  (load-config!)
  (let [config-explorer-server (get-in-config [:explorer :server])]
    (when (server? profile-name)
      (info "open http://localhost:8000/demo to see the demos")
      (explore-directories-start config-explorer-server)
      (goldly-run!))
    (webly-run! profile-name)))