(ns ui.notebook.view.segment-menu
  (:require
   [re-frame.core :as rf]))

(defn link-fn [fun text]
  [:a.bg-blue-300.cursor-pointer.hover:bg-red-700.m-1
   {:on-click fun} text])

(defn link-dispatch [rf-evt text]
  (link-fn #(rf/dispatch rf-evt) text))

(defn fa-dispatch [fa d]
  [:a {:class    [:lg:inline-block :lg:mt-0]
       :on-click #(rf/dispatch d)}
   [:i {:class fa}]])

(defn header-ico [fa-icon rf-dispatch]
  [:a {:on-click #(rf/dispatch rf-dispatch)
       :class "hover:text-blue-700 mr-1"}
   [:i {:class (str "fa-lg pl-1 " fa-icon)}]])

(defn top-left [child]
  [:div.w-full ; .place-self-center
   {:style {:position "relative"
            ;:float "top"
            :left "20px"
            :top "50px"
            ;:width "100%"
            }}
   [:div {:style {:position "absolute"
                  :z-index 5000
                  :left "20px"
                  :top "50px"
                  :width "50px"
                  :height "50px"
                  :border "none"}}
    child]])
(defn bottom-left [child]
  [:div.w-full ; .place-self-center
   {:style {:position "relative"
            :left "20x"
            :width "100%"}}
   [:div {:style {:position "absolute"
                  :z-index 5000
                  :bottom "-50px"
                  :width "50px"
                  :height "50px"
                  :border "none"}}
    child]])

(defn bottom-center [child]
  [:div.w-full ; .place-self-center
   {:style {:position "relative"
            :left "50%"
            ;:transform "translateX(-50%)"
            ;:margin-left "auto"
            ;:margin-right "auto"
            :width "100%"}}
   [:div {:style {:position "absolute"
                  :z-index 5000
                ; :margin-left "auto"

;:margin-right "auto"
             ; :left "50px"
               ;:right "100px"
                  :bottom "-50px"
                  :width "50px"
                  :height "50px"
                  :border "none"}}
    child]])

(defn menu-center [segment]
  (when (= (:type segment) :code)
    [:div.mt-1.mb-1.h-8.flex.flex-row.text-grey-darkest.hover:text-blue-dark
     [header-ico "fas fa-trash-alt" [:segment-active/delete]]
     [header-ico "fas fa-pen-square" [:segment/type-toggle]]
     [header-ico "far fa-calendar" [:segment/clear]]
     [header-ico "fa fa-microchip" [:segment-active/eval]]]))

(defn menu-top-left [segment]
  (when (= (:type segment) :code)
    [:div.mt-1.mb-1.h-8.flex.flex-row.text-grey-darkest.hover:text-blue-dark
     [header-ico "fas fa-plus-circle" [:segment/new-above]]
     [header-ico "fas fa-arrow-circle-up" [:segment/move-pos-up]]]))
(defn menu-bottom-left [segment]
  (when (= (:type segment) :code)
    [:div.mt-1.mb-1.h-8.flex.flex-row.text-grey-darkest.hover:text-blue-dark
     [header-ico "fas fa-plus-circle" [:segment/new-below]]
     [header-ico "fas fa-arrow-circle-down" [:segment/move-pos-down]]]))

(defn cell-menu [segment]
  [:div
   ;[top-left  ; not aligning to top of segment
   ; [menu-top-left segment]]
   [bottom-left
    [menu-bottom-left segment]]
   [bottom-center
    [menu-center segment]]])
