(ns picasso.paint.default
  (:require
   [taoensso.timbre :refer [errorf]]
   [picasso.protocols :refer [paint]]))

(defmethod paint :default [{:keys [type] :as picasso-spec}]
  (errorf "no painter found for type: %s spec: %s" type picasso-spec)
  [:div.bg-red-300.border-solid
   [:h1 (str "No painter found for type: [" type "] ")]
   [:p (pr-str picasso-spec)]])



