(ns notebook.keybindings)

(def keybindings-notebook
  [; segment navigation
   {:kb "alt-up"          :handler [:notebook/move :up]      :desc "Move to prior segment"}
   {:kb "alt-down"        :handler [:notebook/move :down]    :desc "Move to next segment"}

   ; segment modify
   {:kb "alt-g l"         :handler [:segment-active/kernel-toggle]  :desc "Language Toggle"}
   {:kb "alt-g i"         :handler [:segment/new-above]      :desc "Create a new segment above active segment"}
   {:kb "alt-g b"         :handler [:segment/new-below]      :desc "Insert a new segment below active segment"}
   {:kb "alt-g x"         :handler [:segment-active/delete]  :desc "Delete the active segment"}
   {:kb "alt-g v"         :handler [:segment-active/toggle-view] :desc "switch markdown/code view in active segment"}
   ; clear
   {:kb "ctrl-backspace"  :handler [:segment-active/clear]  :desc "Clear the output of active segment"}
   {:kb "alt-shift-backspace" :handler [:notebook/clear-all]    :desc "Clear the output of all code segments."}

   ; eval
   ;{:kb "alt-shift-enter"     :handler [:notebook/evaluate-all] :desc "Evaluate all segments."}
   {:kb "ctrl-shift-enter" :handler [:notebook/evaluate-all]         :desc "Evaluate all segments"}
   {:kb "ctrl-enter" :handler [:segment-active/eval]               :desc "Evaluate the highlighted segment"}

   {:kb "alt-g 1" :handler [:notebook/layout :vertical] :desc "Layout: Vertical"}
   {:kb "alt-g 2" :handler [:notebook/layout :horizontal] :desc "Layout: Horizontal"}
   {:kb "alt-g 3" :handler [:notebook/layout :single] :desc "Layout: Single"}
   {:kb "alt-g 4" :handler [:notebook/layout :stacked] :desc "Layout: Stacked"}

   ; document
   {:kb "alt-g n" :handler [:document/new]           :desc "New notebook"}
   {:kb "alt-g s"             :handler [:notebook/save]         :desc "Save Notebook"}
   {:kb "alt-shift-g s"       :handler [:document/save-as]      :desc "Save As"}])
