(ns ui.notebook.loader.list
  (:require
   [taoensso.timbre :as timbre :refer-macros [debugf info warn error]]
   [re-frame.core :as rf]))

(rf/reg-event-db
 :notebook-list/set
 (fn [db [_ nb-list]]
   (warn "setting nb list: " (pr-str nb-list))
   (let [nb-lists (or (get-in db [:notebook/lists]) {})]
     (if-let [name (:name nb-list)]
       (assoc-in db [:notebook/lists] (assoc nb-lists name nb-list))
       db))))

(rf/reg-sub
 :notebook-lists
 (fn [db _]
   (or (get-in db [:notebook/lists]) {})))
