;; **
;;; # Gorilla Plots combined with FlexGrid
;; **


(ns demo.notebook.gorilla-plot.flexgrid
  (:require
   [pinkgorilla.vega.plot.core :refer [list-plot bar-chart compose histogram plot]]))

;; @@ [clj]
(def d
  [1 3 5 7 9 5 4 6 9 8 3 5 6])
;; @@
;; ->
;;; 
;; <-
;; =>
;;; [["^ ","~:type","~:hiccup","~:content",["~:span",["^ ","~:class","clj-var"],"#'absolute-windy/d"]]]
;; <=

;; @@ [clj]
(def p (list-plot d :joined true :plot-size 200 :aspect-ratio 1.6 :opacity 0.8 :plot-range [:all :all]))
;; @@
;; ->
;;; 
;; <-
;; =>
;;; [["^ ","~:type","~:hiccup","~:content",["~:span",["^ ","~:class","clj-var"],"#'absolute-windy/p"]]]
;; <=

;; @@ [clj]
p
;; @@
;; ->
;;; 
;; <-
;; =>
;;; [["^ ","~:type","~:reagent","~:content",["^ ","~:hiccup",["~'user/vega",["^ ","~:$schema","https://vega.github.io/schema/vega/v5.json","~:width",200,"~:height",125,"~:padding",["^ ","~:top",10,"~:left",55,"~:bottom",40,"~:right",10],"~:data",[["^ ","~:name","8db1c8ab-0272-4fe0-854d-8028725ecf11","~:values",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"~:marks",[["^ ","^0","line","~:from",["^ ","^=","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"~:encode",["^ ","~:enter",["^ ","~:x",["^ ","~:scale","x","~:field","x"],"~:y",["^ ","^D","y","^E","y"],"~:stroke",["^ ","~:value","#FF29D2"],"~:strokeWidth",["^ ","^G",2],"~:strokeOpacity",["^ ","^G",0.8]]]]],"~:scales",[["^ ","^>","x","^0","linear","~:range","width","~:zero",false,"~:domain",["^ ","^=","8db1c8ab-0272-4fe0-854d-8028725ecf11","^E","x"]],["^ ","^>","y","^0","linear","^K","height","~:nice",true,"^L",false,"^M",["^ ","^=","8db1c8ab-0272-4fe0-854d-8028725ecf11","^E","y"]]],"~:axes",[["^ ","~:orient","bottom","^D","x"],["^ ","^P","left","^D","y"]]]],"~:map-keywords",true]]]
;; <=

;; @@ [clj]
^:R [:div {:style {:display "flex"
                   ;:min-height "70vh" 
                   :align-items "left"
                   :flex-wrap "wrap"
                   :justify-content "left"}}
     (repeat 20 p)]
;; @@
;; ->
;;; 
;; <-
;; =>
;;; [["^ ","~:type","~:reagent","~:content",["^ ","~:hiccup",["~:div",["^ ","~:style",["^ ","~:display","flex","~:align-items","left","~:flex-wrap","wrap","~:justify-content","left"]],["~#list",[["~'user/vega",["^ ","~:$schema","https://vega.github.io/schema/vega/v5.json","~:width",200,"~:height",125,"~:padding",["^ ","~:top",10,"~:left",55,"~:bottom",40,"~:right",10],"~:data",[["^ ","~:name","8db1c8ab-0272-4fe0-854d-8028725ecf11","~:values",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"~:marks",[["^ ","^0","line","~:from",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"~:encode",["^ ","~:enter",["^ ","~:x",["^ ","~:scale","x","~:field","x"],"~:y",["^ ","^K","y","^L","y"],"~:stroke",["^ ","~:value","#FF29D2"],"~:strokeWidth",["^ ","^N",2],"~:strokeOpacity",["^ ","^N",0.8]]]]],"~:scales",[["^ ","^E","x","^0","linear","~:range","width","~:zero",false,"~:domain",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","~:nice",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"~:axes",[["^ ","~:orient","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]],["^;",["^ ","^<","https://vega.github.io/schema/vega/v5.json","^=",200,"^>",125,"^?",["^ ","^@",10,"^A",55,"^B",40,"^C",10],"^D",[["^ ","^E","8db1c8ab-0272-4fe0-854d-8028725ecf11","^F",[["^ ","~:x",0,"~:y",1],["^ ","~:x",1,"~:y",3],["^ ","~:x",2,"~:y",5],["^ ","~:x",3,"~:y",7],["^ ","~:x",4,"~:y",9],["^ ","~:x",5,"~:y",5],["^ ","~:x",6,"~:y",4],["^ ","~:x",7,"~:y",6],["^ ","~:x",8,"~:y",9],["^ ","~:x",9,"~:y",8],["^ ","~:x",10,"~:y",3],["^ ","~:x",11,"~:y",5],["^ ","~:x",12,"~:y",6]]]],"^G",[["^ ","^0","line","^H",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11"],"^I",["^ ","^J",["^ ","~:x",["^ ","^K","x","^L","x"],"~:y",["^ ","^K","y","^L","y"],"^M",["^ ","^N","#FF29D2"],"^O",["^ ","^N",2],"^P",["^ ","^N",0.8]]]]],"^Q",[["^ ","^E","x","^0","linear","^R","width","^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","x"]],["^ ","^E","y","^0","linear","^R","height","^U",true,"^S",false,"^T",["^ ","^D","8db1c8ab-0272-4fe0-854d-8028725ecf11","^L","y"]]],"^V",[["^ ","^W","bottom","^K","x"],["^ ","^W","left","^K","y"]]]]]]],"~:map-keywords",true]]]
;; <=

;; @@ [clj]

;; @@
;; ->
;;; 
;; <-
;; =>
;;; []
;; <=
