(ns demo.notebook.gorilla-plot.vega)

;;; # RAW VEGA PLOTS (stolen from the official vega samples)

(def s
  {:$schema "https://vega.github.io/schema/vega/v5.json",
   :height 350,
   :description "An annotated line chart of the population of Falkensee, Germany.",
   :legends
   [{:fill "color",
     :title "Period",
     :orient "top-left",
     :offset 8,
     :encode
     {:symbols
      {:update
       {:strokeWidth {:value 2},
        :shape {:value "square"},
        :opacity {:value 0.3}}}}}],
   :config {:title {:fontSize 16}},
   :axes
   [{:orient "left",
     :scale "y",
     :title "Population",
     :titlePadding 10,
     :grid true}
    {:orient "bottom",
     :scale "x",
     :format "d",
     :title "Year",
     :tickCount 15}],
   :width 500,
   :scales
   [{:name "x",
     :type "linear",
     :range "width",
     :zero false,
     :domain {:data "table", :field "year"}}
    {:name "y",
     :type "linear",
     :range "height",
     :nice true,
     :zero true,
     :domain
     {:data "table", :field "population"}}
    {:name "color",
     :type "ordinal",
     :domain {:data "annotation", :field "mtext"},
     :range ["black" "red"]}],
   :title
   {:text
    {:signal
     "'Population of Falkensee from ' + years[0] + ' to ' + years[1]"}},
   :padding 5,
   :marks
   [{:type "rect",
     :from {:data "annotation"},
     :encode
     {:enter
      {:x {:scale "x", :field "start"},
       :x2 {:scale "x", :field "end"},
       :y {:value 0},
       :y2 {:signal "height"},
       :fill {:scale "color", :field "mtext"},
       :opacity {:value 0.2}}}}
    {:type "line",
     :from {:data "table"},
     :encode
     {:enter
      {:interpolate {:value "monotone"},
       :x {:scale "x", :field "year"},
       :y {:scale "y", :field "population"},
       :stroke {:value "steelblue"},
       :strokeWidth {:value 3}}}}
    {:type "symbol",
     :from {:data "table"},
     :encode
     {:enter
      {:x {:scale "x", :field "year"},
       :y {:scale "y", :field "population"},
       :stroke {:value "steelblue"},
       :strokeWidth {:value 1.5},
       :fill {:value "white"},
       :size {:value 30}}}}],

   :data
   [{:name "table",
     :values
     [{:year 1875, :population 1309}
      {:year 1890, :population 1558}
      {:year 1910, :population 4512}
      {:year 1925, :population 8180}
      {:year 1933, :population 15915}
      {:year 1939, :population 24824}
      {:year 1946, :population 28275}
      {:year 1950, :population 29189}
      {:year 1964, :population 29881}
      {:year 1971, :population 26007}
      {:year 1981, :population 24029}
      {:year 1985, :population 23340}
      {:year 1989, :population 22307}
      {:year 1990, :population 22087}
      {:year 1991, :population 22139}
      {:year 1992, :population 22105}
      {:year 1993, :population 22242}
      {:year 1994, :population 22801}
      {:year 1995, :population 24273}
      {:year 1996, :population 25640}
      {:year 1997, :population 27393}
      {:year 1998, :population 29505}
      {:year 1999, :population 32124}
      {:year 2000, :population 33791}
      {:year 2001, :population 35297}
      {:year 2002, :population 36179}
      {:year 2003, :population 36829}
      {:year 2004, :population 37493}
      {:year 2005, :population 38376}
      {:year 2006, :population 39008}
      {:year 2007, :population 39366}
      {:year 2008, :population 39821}
      {:year 2009, :population 40179}
      {:year 2010, :population 40511}
      {:year 2011, :population 40465}
      {:year 2012, :population 40905}
      {:year 2013, :population 41258}
      {:year 2014, :population 41777}],
     :transform
     [{:type "extent",
       :field "year",
       :signal "years"}]}
    {:name "annotation",
     :values
     [{:start 1933, :end 1945, :mtext "Nazi Rule"}
      {:start 1948, :end 1989, :mtext "GDR (East Germany)"}]}]})

^:R ['user/vega s]

(def x {:$schema
        "https://vega.github.io/schema/vega-lite/v4.json",
        :data {:url "/r/data/sp500.csv"},
        :vconcat
        [{:width 480,
          :mark "area",
          :encoding
          {:x
           {:field "date",
            :type "temporal",
            :scale {:domain {:selection "brush"}},
            :axis {:title ""}},
           :y {:field "price", :type "quantitative"}}}
         {:width 480,
          :height 60,
          :mark "area",
          :selection
          {:brush
           {:type "interval", :encodings ["x"]}},
          :encoding
          {:x {:field "date", :type "temporal"},
           :y
           {:field "price",
            :type "quantitative",
            :axis {:tickCount 3, :grid false}}}}]})

^:R ['user/vega x]
