
;;; # Timeseries tests (incl multi plot timeseries)


(ns demo.notebook.gorilla-plot.timeseries-multi
  (:require
   [clj-time.core :as t]
   [clj-time.coerce :as tc]
   [pinkgorilla.vega.plot.core :refer [list-plot bar-chart compose histogram plot timeseries-plot multi-plot]]))

;;; Some data to look at.

(defn dt [year month day]
  (-> (t/date-time year month day)
      (tc/to-long)))

(def d [[(dt 1986 10 30) 1]
        [(dt 1987 10 30) 2]
        [(dt 1988 10 30) 3]
        [(dt 1999 10 30) 4]
        [(dt 1986 12 30) 5]])
d

;;; List plot plots data in the style of a scatter plot by default.

(timeseries-plot d)

;;; There are a number of options that can be given to the plot. At the moment your best bet is to peek at the source code to see what they are.

(timeseries-plot d :joined true :plot-size 400 :aspect-ratio 1.6 :opacity 0.5 :plot-range [:all :all])

;; test if vega errors are displayed correctly
;; should give error: "timeXXX"
^:R [:vega {:$schema "https://vega.github.io/schema/vega/v5.json", :width 400, :height 250.0, :padding {:top 10, :left 55, :bottom 40, :right 10}, :data [{:name "5c3ec60e-f5ad-42eb-a0cd-463ae34424b2", :values [{:x 531014400000, :y 1} {:x 562550400000, :y 2} {:x 594172800000, :y 3} {:x 625708800000, :y 4} {:x 536284800000, :y 5}]}], :marks [{:type "lineo", :from {:data "5c3ec60e-f5ad-42eb-a0cd-463ae34424b2"}, :encode {:enter {:x {:scale "x", :field "x"}, :y {:scale "y", :field "y"}, :stroke {:value "#FF29D2"}, :strokeWidth {:value 2}, :strokeOpacity {:value 0.5}}}}], :scales [{:name "x", :type "timeXXX", :range "width", :zero false, :domain {:data "5c3ec60e-f5ad-42eb-a0cd-463ae34424b2", :field "x"}} {:name "y", :type "linear", :range "height", :nice true, :zero false, :domain {:data "5c3ec60e-f5ad-42eb-a0cd-463ae34424b2", :field "y"}}], :axes [{:orient "bottom", :scale "x"} {:orient "left", :scale "y"}]}]

; print out spec generated by gorilla-plot - so we can see what it does under the hood
; this type of output is not ideal to be copied to https://vega.github.io/editor - see below
(second (timeseries-plot d :joined true :plot-size 400 :aspect-ratio 1.6 :opacity 0.5 :plot-range [:all :all]))

(def a [1 2  4 3 2])
(def b [-1 1 -2 3 0])
(def c [6 5  1 7 5])

(multi-plot {:width 500} {:data a :orient "right" :title "A"})

; make a multi-plot, then take only the vega spec, then render vega-spec via a json rendere
;why? Experiment with the plot in https://vega.github.io/editor
^:R [:p/json  (second (multi-plot {:width 800}
                                  {:data c :orient :left :title "msft" :color "blue" :height 250 :type :point}
                                  [{:data b :orient :left :title "B" :height 50 :type "area"}
                                   {:data a :orient :right :title "A" :color "red" :height 50}]))]

(multi-plot {:width 800}
            {:data c :orient :left :title "msft" :color "blue" :height 250 :type :point}
            [{:data b :orient :left :title "B" :height 50 :type "area"}
             {:data a :orient :right :title "A" :color "red" :height 50}])

(clojure.repl/doc pinkgorilla.ui.gorilla-plot.multi/multi-plot)
