; This Source Code Form is subject to the terms of the Mozilla Public License,
; v. 2.0. If a copy of the MPL was not distributed with this file, You can
; obtain one at http://mozilla.org/MPL/2.0/.

(ns cemerick.sedan.macros)

(defmacro define-partition!
  "Extends the [type] to the cemerick.sedan.impl/Sedan protocol, additionally
registering its [tag-byte] (which may be a collection if multiple tags map to
the same type) and [decoder-fn] via `register-partition!`.  If a `tag-for`
method is not provided in [sedan-protocol-impls], one will be generated that
always returns [tag-byte]."
  [tag-byte partition-name types decoder-fn & sedan-protocol-impls]
  `(do
     ~@(map #(list 'cemerick.sedan.impl/register-partition!
               % partition-name decoder-fn)
         (if (coll? tag-byte) tag-byte #{tag-byte}))
     ~@(for [type (if (coll? types) types #{types})]
         `(extend-protocol cemerick.sedan.impl/Sedan
            ~type
            ~@(if (some #{'tag-for} (map first sedan-protocol-impls))
                sedan-protocol-impls
                (cons
                  `(~'tag-for [_#] ~tag-byte)
                  sedan-protocol-impls))))))

(defmacro !0
  "Evaluates each expression in turn, returning the first nonzero value, or zero
  if all expressions evaluate to zero."
  [& exprs]
  (if (seq exprs)
    `(let [v# ~(first exprs)]
       (if (zero? v#)
         (!0 ~@(rest exprs))
         v#))
    0))


