/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Test;
import org.reficio.ws.SoapContext;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.SoapOperation;
import org.reficio.ws.builder.core.Wsdl;
import org.reficio.ws.common.ResourceUtils;
import org.reficio.ws.common.XmlUtils;

public class ServiceComplianceTest {
    private static final Logger log = Logger.getLogger(ServiceComplianceTest.class);

    public static String getTestServiceFolderPath(int testServiceId) {
        String testServiceIdString = testServiceId < 10 ? "0" + testServiceId : "" + testServiceId;
        return "/services/test" + testServiceIdString;
    }

    public static URL getDefinitionUrl(int testServiceId) {
        URL wsdlUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)ServiceComplianceTest.getTestServiceFolderPath(testServiceId), (String)"TestService.wsdl");
        return wsdlUrl;
    }

    public static Definition getDefinition(URL wsdlUrl) throws WSDLException {
        WSDLReaderImpl reader = new WSDLReaderImpl();
        Definition definition = reader.readWSDL(wsdlUrl.getPath());
        return definition;
    }

    public static String getExpectedMessage(int testServiceId, String bindingName, String operationName, MessageType msg) {
        String serviceFolderPath = ServiceComplianceTest.getTestServiceFolderPath(testServiceId);
        String messageFolderPath = String.format("%s/operations/%s", serviceFolderPath, bindingName);
        String fileName = operationName + "." + (MessageType.REQUEST.equals((Object)msg) ? "request" : "response") + ".xml";
        URL fileUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)messageFolderPath, (String)fileName);
        File file = null;
        try {
            file = new File(fileUrl.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(fileUrl.getPath());
        }
        try {
            return FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getExpectedRequest(int testServiceId, String bindingName, String operationName) {
        return ServiceComplianceTest.getExpectedMessage(testServiceId, bindingName, operationName, MessageType.REQUEST);
    }

    public static String getExpectedResponse(int testServiceId, String bindingName, String operationName) {
        return ServiceComplianceTest.getExpectedMessage(testServiceId, bindingName, operationName, MessageType.RESPONSE);
    }

    private static void testService(int testServiceId) throws Exception {
        URL wsdlUrl = ServiceComplianceTest.getDefinitionUrl(testServiceId);
        Wsdl parser = Wsdl.parse((URL)wsdlUrl);
        SoapContext context = SoapContext.builder().exampleContent(false).build();
        for (QName bindingQName : parser.getBindings()) {
            String bindingName = bindingQName.getLocalPart();
            SoapBuilder builder = parser.binding().name(bindingQName).find();
            for (SoapOperation operation : builder.getOperations()) {
                String request = builder.buildInputMessage(operation);
                String expectedRequest = ServiceComplianceTest.getExpectedRequest(testServiceId, bindingName, operation.getOperationName());
                log.info((Object)String.format("Comparing binding=[%s] operation=[%s]", bindingName, operation.getOperationName()));
                log.info((Object)("REQUEST:\n" + request));
                log.info((Object)("EXPECTED_REQUEST:\n" + expectedRequest));
                request = XmlUtils.normalizeAndRemoveValues((String)request);
                expectedRequest = XmlUtils.normalizeAndRemoveValues((String)expectedRequest);
                log.info((Object)("REQUEST_NO_VALUES:\n" + request));
                log.info((Object)("EXPECTED_REQUEST_NO_VALUES:\n" + expectedRequest));
                Assert.assertTrue((boolean)XMLUnit.compareXML((String)expectedRequest, (String)request).identical());
                String response = builder.buildOutputMessage(operation, context);
                String expectedResponse = ServiceComplianceTest.getExpectedResponse(testServiceId, bindingName, operation.getOperationName());
                log.info((Object)("RESPONSE:\n" + response));
                log.info((Object)("EXPECTED_RESPONSE:\n" + expectedResponse));
                response = XmlUtils.normalizeAndRemoveValues((String)response);
                expectedResponse = XmlUtils.normalizeAndRemoveValues((String)expectedResponse);
                log.info((Object)("RESPONSE_NO_VALUES:\n" + response));
                log.info((Object)("EXPECTED_RESPONSE_NO_VALUES:\n" + expectedResponse));
                Assert.assertTrue((boolean)XMLUnit.compareXML((String)expectedResponse, (String)response).identical());
            }
        }
    }

    @Test
    public void testService01() throws Exception {
        ServiceComplianceTest.testService(1);
    }

    @Test
    public void testService02() throws Exception {
        ServiceComplianceTest.testService(2);
    }

    @Test
    public void testService03() throws Exception {
        ServiceComplianceTest.testService(3);
    }

    @Test
    public void testService04() throws Exception {
        ServiceComplianceTest.testService(4);
    }

    @Test
    public void testService05() throws Exception {
        ServiceComplianceTest.testService(5);
    }

    @Test
    public void testService06() throws Exception {
        ServiceComplianceTest.testService(6);
    }

    @Test
    public void testService07() throws Exception {
        ServiceComplianceTest.testService(7);
    }

    @Test
    public void testService08() throws Exception {
        ServiceComplianceTest.testService(8);
    }

    @Test
    public void testService09() throws Exception {
        ServiceComplianceTest.testService(9);
    }

    @Test
    public void testService10() throws Exception {
        ServiceComplianceTest.testService(10);
    }

    @Test
    public void testService11() throws Exception {
        ServiceComplianceTest.testService(11);
    }

    @Test
    public void testService12() throws Exception {
        ServiceComplianceTest.testService(12);
    }

    @Test
    public void testService13() throws Exception {
        ServiceComplianceTest.testService(13);
    }

    @Test
    public void testService14() throws Exception {
        ServiceComplianceTest.testService(14);
    }

    @Test
    public void testService15() throws Exception {
        ServiceComplianceTest.testService(15);
    }

    @Test
    public void testService16() throws Exception {
        ServiceComplianceTest.testService(16);
    }

    @Test
    public void testService17() throws Exception {
        ServiceComplianceTest.testService(17);
    }

    @Test
    public void testService18() throws Exception {
        ServiceComplianceTest.testService(18);
    }

    static enum MessageType {
        REQUEST,
        RESPONSE;

    }
}

