/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder.core;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import org.reficio.ws.SoapBuilderException;
import org.reficio.ws.SoapContext;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.SoapOperationBuilder;
import org.reficio.ws.builder.SoapOperationFinder;
import org.reficio.ws.builder.core.SoapOperationImpl;
import org.reficio.ws.builder.core.SoapUtils;

class SoapOperationFinderImpl
implements SoapOperationFinder {
    private final Binding binding;
    private String operationName;
    private String operationInputName;
    private String operationOutputName;
    private String soapAction;
    private SoapBuilder builder;

    SoapOperationFinderImpl(SoapBuilder builder, Binding binding) {
        this.binding = binding;
        this.builder = builder;
    }

    @Override
    public SoapOperationFinder name(String operationName) {
        Preconditions.checkNotNull((Object)operationName);
        this.operationName = operationName;
        return this;
    }

    @Override
    public SoapOperationFinder soapAction(String soapAction) {
        Preconditions.checkNotNull((Object)soapAction);
        this.soapAction = soapAction;
        return this;
    }

    @Override
    public SoapOperationFinder inputName(String inputName) {
        Preconditions.checkNotNull((Object)inputName);
        this.operationInputName = inputName;
        return this;
    }

    @Override
    public SoapOperationFinder outputName(String outputName) {
        Preconditions.checkNotNull((Object)outputName);
        this.operationOutputName = outputName;
        return this;
    }

    @Override
    public SoapOperationBuilder find() {
        this.validateInput();
        ArrayList<SoapOperationBuilder> found = new ArrayList<SoapOperationBuilder>();
        for (BindingOperation operation : this.binding.getBindingOperations()) {
            boolean condition = true;
            condition &= this.checkOperationName(operation);
            condition &= this.checkSoapAction(operation);
            condition &= this.checkOperationInputName(operation);
            if (!(condition &= this.checkOperationOutputName(operation))) continue;
            found.add(SoapOperationImpl.create(this.builder, this.binding, operation));
            if (found.size() <= 1) continue;
            throw new SoapBuilderException("Operation not unique - found more than one operation");
        }
        if (found.isEmpty()) {
            throw new SoapBuilderException("Found no operations");
        }
        return (SoapOperationBuilder)found.iterator().next();
    }

    @Override
    public SoapOperationBuilder find(SoapContext context) {
        SoapOperationBuilder builder = this.find();
        builder.setContext(context);
        return builder;
    }

    private void validateInput() {
        boolean failed = true;
        failed &= this.operationName == null;
        failed &= this.soapAction == null;
        failed &= this.operationInputName == null;
        if (failed &= this.operationOutputName == null) {
            throw new IllegalArgumentException("All finder properties cannot be null");
        }
    }

    private boolean checkOperationName(BindingOperation op) {
        if (this.operationName != null) {
            return this.operationName.equals(op.getOperation().getName());
        }
        return true;
    }

    private boolean checkSoapAction(BindingOperation op) {
        if (this.soapAction != null) {
            return this.soapAction.equals(SoapUtils.getSOAPActionUri(op));
        }
        return true;
    }

    private boolean checkOperationInputName(BindingOperation op) {
        if (this.operationInputName != null) {
            return this.operationInputName.equals(op.getOperation().getInput().getName());
        }
        return true;
    }

    private boolean checkOperationOutputName(BindingOperation op) {
        if (this.operationOutputName != null) {
            return this.operationOutputName.equals(op.getOperation().getOutput().getName());
        }
        return true;
    }
}

