/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.client.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class MultiX509TrustManager
implements X509TrustManager {
    private final List<X509TrustManager> managers;

    public MultiX509TrustManager(List<X509TrustManager> managers) {
        this.managers = new ArrayList<X509TrustManager>(managers);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        ArrayList<CertificateException> exceptions = new ArrayList<CertificateException>();
        try {
            for (X509TrustManager manager : this.managers) {
                manager.checkClientTrusted(x509Certificates, authType);
            }
        }
        catch (CertificateException ex) {
            exceptions.add(ex);
        }
        if (exceptions.size() >= this.managers.size()) {
            throw (CertificateException)exceptions.iterator().next();
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        ArrayList<CertificateException> exceptions = new ArrayList<CertificateException>();
        try {
            for (X509TrustManager manager : this.managers) {
                manager.checkServerTrusted(x509Certificates, authType);
            }
        }
        catch (CertificateException ex) {
            exceptions.add(ex);
        }
        if (exceptions.size() >= this.managers.size()) {
            throw (CertificateException)exceptions.iterator().next();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (X509TrustManager manager : this.managers) {
            for (X509Certificate cert : manager.getAcceptedIssuers()) {
                certs.add(cert);
            }
        }
        return certs.toArray(new X509Certificate[0]);
    }
}

