/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.common;

import java.io.InputStream;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.reficio.ws.common.ResourceUtils;

public class ResourceUtilsTest {
    @Test(expected=IllegalArgumentException.class)
    public void testResourceLoading_failed() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath(System.class, (String)"org/reficio/ws/common/test", (String)"soapEncoding.xsd123123");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResourceLoading_failed_noPackage() {
        URL url = ResourceUtils.getResource(System.class, (String)"asdasdasdasd.txt");
    }

    @Test
    public void testResourceLoading_noLeadingTrailing() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath(System.class, (String)"org/reficio/ws/common/test", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_noLeadingTrailing_noPackage() {
        URL url = ResourceUtils.getResource(System.class, (String)"org/reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_noLeading() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath(System.class, (String)"org/reficio/ws/common/test/", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_noLeading_noPackage() {
        URL url = ResourceUtils.getResource(System.class, (String)"org/reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_multipleLeading() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath(System.class, (String)"//////org/reficio/ws/common/test/", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_multipleLeading_noPackage() {
        URL url = ResourceUtils.getResource(System.class, (String)"//////org/reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoadingNoTrailing() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath(System.class, (String)"/org/reficio/ws/common/test", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoadingNoTrailing_noPackage() {
        URL url = ResourceUtils.getResource(System.class, (String)"/org/reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_whiteSpaces() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath(System.class, (String)"  /org/reficio/ws/common/test  ", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_whiteSpaces_noPackage() {
        URL url = ResourceUtils.getResource(System.class, (String)"  /org/reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_multipleInner() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath(System.class, (String)"/org///reficio////ws/common/////test", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_multipleInner_noPackage() {
        URL url = ResourceUtils.getResource(System.class, (String)"/org///reficio////ws/common/////test/////soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_multipleTrailing() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath(System.class, (String)"org/reficio/ws/common/test//////", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_multipleTrailing_noPackage() {
        URL url = ResourceUtils.getResource(System.class, (String)"org/reficio/ws/common/test//////soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_notNormalized() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath(System.class, (String)"org/../org/reficio/../reficio/ws/common/test/", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_notNormalized_noPackage() {
        URL url = ResourceUtils.getResource(System.class, (String)"org/../org/reficio/../reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoading_notNormalized_asStream() {
        InputStream stream = ResourceUtils.getResourceWithAbsolutePackagePathAsStream(System.class, (String)"/org/../org/reficio/../reficio/ws/common/test/", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoading_notNormalized_asStream_noPackage() {
        InputStream stream = ResourceUtils.getResourceAsStream(System.class, (String)"/org/../org/reficio/../reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoadingObject() {
        InputStream stream = ResourceUtils.getResourceWithAbsolutePackagePathAsStream(Object.class, (String)"/org/reficio/ws/common/test/", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoadingObject_noPackage() {
        InputStream stream = ResourceUtils.getResourceAsStream(Object.class, (String)"/org/reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoadingThis() {
        InputStream stream = ResourceUtils.getResourceWithAbsolutePackagePathAsStream(ResourceUtilsTest.class, (String)"/org/reficio/ws/common/test/", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoadingThis_noPackage() {
        InputStream stream = ResourceUtils.getResourceAsStream(ResourceUtilsTest.class, (String)"/org/reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoadingGetClass() {
        InputStream stream = ResourceUtils.getResourceWithAbsolutePackagePathAsStream(this.getClass(), (String)"/org/reficio/ws/common/test/", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoadingGetClass_noPackage() {
        InputStream stream = ResourceUtils.getResourceAsStream(this.getClass(), (String)"/org/reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoadingNoClass() {
        InputStream stream = ResourceUtils.getResourceWithAbsolutePackagePathAsStream((String)"/org/reficio/ws/common/test/", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoadingNoClass_noPackage() {
        InputStream stream = ResourceUtils.getResourceAsStream((String)"/org/reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testResourceLoadingNotNormalizedNoClass() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath((String)"org/../org/reficio/../reficio/ws/common/test/", (String)"soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoadingNotNormalizedNoClass_noPackage() {
        URL url = ResourceUtils.getResource((String)"org/../org/reficio/../reficio/ws/common/test/soapEncoding.xsd");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoadingSpaceInTheResource() {
        URL url = ResourceUtils.getResourceWithAbsolutePackagePath((String)"my folder", (String)"resource.txt");
        Assert.assertNotNull((Object)url);
    }

    @Test
    public void testResourceLoadingSpaceInTheResource_noPackage() {
        URL url = ResourceUtils.getResource((String)"my folder/resource.txt");
        Assert.assertNotNull((Object)url);
    }
}

