/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.it;

import java.security.KeyStore;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.littleshoot.proxy.DefaultHttpProxyServer;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.ProxyAuthorizationHandler;
import org.reficio.ws.client.SoapClientException;
import org.reficio.ws.client.TransmissionException;
import org.reficio.ws.client.core.Security;
import org.reficio.ws.client.core.SoapClient;
import org.reficio.ws.it.AbstractCooperationTest;
import org.reficio.ws.it.util.ClientBuilder;
import org.reficio.ws.it.util.SslTunnel;
import org.reficio.ws.server.core.SoapServer;

public class HttpsProxyHttpCooperationTest
extends AbstractCooperationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final int PROXY_PORT = 9797;

    @Before
    public void initializeServer() {
        this.server = SoapServer.builder().httpPort(9696).build();
        this.server.start();
    }

    @After
    public void destroyServer() {
        this.server.stop();
    }

    public HttpProxyServer initProxy() {
        DefaultHttpProxyServer proxyServer = new DefaultHttpProxyServer(9797);
        proxyServer.start(true, true);
        return proxyServer;
    }

    @Test
    public void testService1_httpsProxy_defaultProxySetting() throws Exception {
        HttpProxyServer proxyServer = this.initProxy();
        try {
            this.verifyServiceBehavior(1, new ClientBuilder(){

                @Override
                public SoapClient buildClient(String endpointUrl) {
                    return SoapClient.builder().endpointUri("http://" + endpointUrl).build();
                }
            });
        }
        finally {
            proxyServer.stop();
        }
    }

    @Test
    public void testService1_httpsProxy_directProxy() throws Exception {
        HttpProxyServer proxyServer = this.initProxy();
        try {
            this.verifyServiceBehavior(1, new ClientBuilder(){

                @Override
                public SoapClient buildClient(String endpointUrl) {
                    return SoapClient.builder().endpointUri("http://" + endpointUrl).build();
                }
            });
        }
        finally {
            proxyServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testService1_httpsProxy_noAuthentication() throws Exception {
        KeyStore ks = this.readKeyStore(HttpsProxyHttpCooperationTest.getKeyStoreUrlOne(), this.getKeyStorePassword(), "JKS");
        SslTunnel tunnel = new SslTunnel(ks, this.getKeyStorePassword(), 9898, "localhost", 9797);
        tunnel.start();
        HttpProxyServer proxyServer = this.initProxy();
        try {
            final Security securityContext = Security.builder().trustStoreUrl(HttpsProxyHttpCooperationTest.getKeyStoreUrlOne()).trustStorePassword(this.getKeyStorePassword()).build();
            this.verifyServiceBehavior(1, new ClientBuilder(){

                @Override
                public SoapClient buildClient(String endpointUrl) {
                    return SoapClient.builder().endpointUri("http://" + endpointUrl).proxyUri("https://127.0.0.1:9898").proxySecurity(securityContext).build();
                }
            });
        }
        finally {
            tunnel.stop();
            proxyServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testService1_httpProxy_basicAuthentication_success() throws Exception {
        KeyStore ks = this.readKeyStore(HttpsProxyHttpCooperationTest.getKeyStoreUrlOne(), this.getKeyStorePassword(), "JKS");
        SslTunnel tunnel = new SslTunnel(ks, this.getKeyStorePassword(), 9898, "localhost", 9797);
        tunnel.start();
        HttpProxyServer proxyServer = this.initProxy();
        proxyServer.addProxyAuthenticationHandler(new ProxyAuthorizationHandler(){

            public boolean authenticate(String user, String pass) {
                return user.equals("tom") && pass.equals("007");
            }
        });
        try {
            final Security security = Security.builder().authBasic("tom", "007").trustStoreUrl(HttpsProxyHttpCooperationTest.getKeyStoreUrlOne()).trustStorePassword(this.getKeyStorePassword()).build();
            this.verifyServiceBehavior(1, new ClientBuilder(){

                @Override
                public SoapClient buildClient(String endpointUrl) {
                    return SoapClient.builder().endpointUri("http://" + endpointUrl).proxyUri("https://127.0.0.1:9898").proxySecurity(security).build();
                }
            });
        }
        finally {
            tunnel.stop();
            proxyServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testService1_httpProxy_basicAuthentication_failure() throws Exception {
        this.exception.expect(TransmissionException.class);
        this.exception.expectMessage("[407]");
        KeyStore ks = this.readKeyStore(HttpsProxyHttpCooperationTest.getKeyStoreUrlOne(), this.getKeyStorePassword(), "JKS");
        SslTunnel tunnel = new SslTunnel(ks, this.getKeyStorePassword(), 9898, "localhost", 9797);
        tunnel.start();
        HttpProxyServer proxyServer = this.initProxy();
        proxyServer.addProxyAuthenticationHandler(new ProxyAuthorizationHandler(){

            public boolean authenticate(String user, String pass) {
                return user.equals("tom") && pass.equals("007");
            }
        });
        final Security props = Security.builder().authBasic("james", "003").trustStoreUrl(HttpsProxyHttpCooperationTest.getKeyStoreUrlOne()).trustStorePassword(this.getKeyStorePassword()).build();
        try {
            this.verifyServiceBehavior(1, new ClientBuilder(){

                @Override
                public SoapClient buildClient(String endpointUrl) {
                    return SoapClient.builder().endpointUri("http://" + endpointUrl).proxyUri("https://127.0.0.1:9898").proxySecurity(props).build();
                }
            });
        }
        finally {
            tunnel.stop();
            proxyServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testService1_httpProxy_basicAuthentication_wrongKeystore_failure() throws Exception {
        this.exception.expect(SoapClientException.class);
        this.exception.expectMessage("peer not authenticated");
        KeyStore ks = this.readKeyStore(HttpsProxyHttpCooperationTest.getKeyStoreUrlTwo(), this.getKeyStorePassword(), "JKS");
        SslTunnel tunnel = new SslTunnel(ks, this.getKeyStorePassword(), 9898, "localhost", 9797);
        tunnel.start();
        HttpProxyServer proxyServer = this.initProxy();
        proxyServer.addProxyAuthenticationHandler(new ProxyAuthorizationHandler(){

            public boolean authenticate(String user, String pass) {
                return user.equals("tom") && pass.equals("007");
            }
        });
        final Security props = Security.builder().authBasic("tom", "007").trustStoreUrl(HttpsProxyHttpCooperationTest.getKeyStoreUrlOne()).trustStorePassword(this.getKeyStorePassword()).build();
        try {
            this.verifyServiceBehavior(1, new ClientBuilder(){

                @Override
                public SoapClient buildClient(String endpointUrl) {
                    return SoapClient.builder().endpointUri("http://" + endpointUrl).proxyUri("https://127.0.0.1:9898").proxySecurity(props).build();
                }
            });
        }
        finally {
            tunnel.stop();
            proxyServer.stop();
        }
    }
}

