/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.it.util;

import java.net.URL;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reficio.ws.SoapContext;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.core.Wsdl;
import org.reficio.ws.common.ResourceUtils;
import org.reficio.ws.server.core.SoapServer;
import org.reficio.ws.server.responder.AutoResponder;
import org.reficio.ws.server.responder.RequestResponder;

public class TestUtils {
    private static final Log log = LogFactory.getLog(TestUtils.class);

    public static Wsdl createParserForService(int testServiceId) throws WSDLException {
        String path = TestUtils.getTestServiceFolderPath(testServiceId);
        URL wsdlUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)path, (String)"TestService.wsdl");
        Wsdl parser = Wsdl.parse((URL)wsdlUrl);
        Assert.assertNotNull((Object)parser);
        return parser;
    }

    public static String formatContextPath(int testServiceId, QName bindingName) {
        return "/service" + TestUtils.formatServiceId(testServiceId) + "_" + bindingName.getLocalPart();
    }

    public static String getTestServiceFolderPath(int testServiceId) {
        String testServiceIdString = TestUtils.formatServiceId(testServiceId);
        return "/services/test" + testServiceIdString;
    }

    public static String formatServiceId(int testServiceId) {
        return testServiceId < 10 ? "0" + testServiceId : "" + testServiceId;
    }

    public static void registerService(SoapServer server, int testServiceId) throws WSDLException {
        Wsdl parser = TestUtils.createParserForService(testServiceId);
        TestUtils.registerAutoResponderForAllServiceBindings(server, testServiceId, parser);
    }

    public static void registerService(SoapServer server, int testServiceId, Wsdl parser) throws WSDLException {
        TestUtils.registerAutoResponderForAllServiceBindings(server, testServiceId, parser);
    }

    public static void registerAutoResponderForAllServiceBindings(SoapServer server, int testServiceId, Wsdl parser) {
        for (QName bindingName : parser.getBindings()) {
            String contextPath = TestUtils.formatContextPath(testServiceId, bindingName);
            log.info((Object)String.format("Registering auto responder for service [%d] undex context path [%s]", testServiceId, contextPath));
            SoapContext context = SoapContext.builder().exampleContent(true).build();
            SoapBuilder builder = parser.binding().name(bindingName).find();
            server.registerRequestResponder(contextPath, (RequestResponder)new AutoResponder(builder, context));
        }
    }
}

