/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.it;

import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.OperationType;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reficio.ws.SoapContext;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.SoapOperation;
import org.reficio.ws.builder.core.SoapUtils;
import org.reficio.ws.builder.core.Wsdl;
import org.reficio.ws.client.core.SoapClient;
import org.reficio.ws.common.ResourceUtils;
import org.reficio.ws.common.XmlUtils;
import org.reficio.ws.it.util.ClientBuilder;
import org.reficio.ws.it.util.TestUtils;
import org.reficio.ws.server.core.SoapServer;

public abstract class AbstractCooperationTest {
    private static final Log log = LogFactory.getLog(AbstractCooperationTest.class);
    public static final String HOST_URL = "localhost";
    public static final int HOST_PORT = 9696;
    protected SoapServer server;

    protected static URL getKeyStoreUrlOne() {
        return ResourceUtils.getResourceWithAbsolutePackagePath((String)"/keystores/single-cert-keystore", (String)".keystore_1");
    }

    protected static URL getKeyStoreUrlTwo() {
        return ResourceUtils.getResourceWithAbsolutePackagePath((String)"/keystores/single-cert-keystore", (String)".keystore_2");
    }

    protected static URL getMultiKeyStoreUrl() {
        return ResourceUtils.getResourceWithAbsolutePackagePath((String)"/keystores/multi-cert-keystore", (String)".keystore");
    }

    protected String getKeyStorePassword() {
        return "changeit";
    }

    protected void verifyServiceBehavior(int testServiceId, ClientBuilder clientBuilder) throws Exception {
        this.verifyServiceBehavior(testServiceId, null, clientBuilder);
    }

    protected void verifyServiceBehavior(int testServiceId) throws Exception {
        this.verifyServiceBehavior(testServiceId, new ClientBuilderImpl());
    }

    protected void verifyServiceBehavior(int testServiceId, Boolean postSoapAction, ClientBuilder clientBuilder) throws Exception {
        log.info((Object)String.format("------------------- TESTING SERVICE [%d] -----------------------", testServiceId));
        Wsdl parser = TestUtils.createParserForService(testServiceId);
        this.registerHandler(this.server, testServiceId, parser);
        for (QName bindingName : parser.getBindings()) {
            SoapBuilder builder = parser.binding().name(bindingName).find();
            String contextPath = TestUtils.formatContextPath(testServiceId, builder.getBindingName());
            String endpointUrl = this.formatEndpointAddress(contextPath);
            for (SoapOperation operation : builder.getOperations()) {
                if (postSoapAction == null) {
                    this.testOperation(clientBuilder, builder, operation, endpointUrl, Boolean.TRUE);
                    this.testOperation(clientBuilder, builder, operation, endpointUrl, Boolean.FALSE);
                    continue;
                }
                this.testOperation(clientBuilder, builder, operation, endpointUrl, postSoapAction);
            }
        }
    }

    protected void verifyServiceBehavior(int testServiceId, Boolean postSoapAction) throws Exception {
        this.verifyServiceBehavior(testServiceId, postSoapAction, new ClientBuilderImpl());
    }

    private void testOperation(ClientBuilder clientBuilder, SoapBuilder soapBuilder, SoapOperation operation, String endpointUrl, Boolean postSoapAction) throws Exception {
        String response;
        log.info((Object)("Testing operation: " + operation));
        String request = soapBuilder.buildInputMessage(operation);
        if (!operation.isInputSoapEncoded()) {
            soapBuilder.validateInputMessage(operation, request);
        }
        Assert.assertTrue((String)"Generated request is empty!", (request.length() > 0 ? 1 : 0) != 0);
        Binding binding = soapBuilder.getBinding();
        BindingOperation op = binding.getBindingOperation(operation.getOperationName(), operation.getOperationInputName(), operation.getOperationOutputName());
        SoapClient client = clientBuilder.buildClient(endpointUrl);
        if (postSoapAction.booleanValue()) {
            String soapAction = SoapUtils.getSOAPActionUri((BindingOperation)op);
            response = this.postRequest(client, request, soapAction);
        } else {
            response = this.postRequest(client, request);
        }
        SoapContext context = SoapContext.builder().exampleContent(true).build();
        if (op.getOperation().getStyle().equals(OperationType.REQUEST_RESPONSE)) {
            String expectedResponse = soapBuilder.buildOutputMessage(operation, context);
            if (!operation.isOutputSoapEncoded()) {
                soapBuilder.validateOutputMessage(operation, response);
            }
            Assert.assertTrue((String)"Generated expectedResponse is empty!", (expectedResponse.length() > 0 ? 1 : 0) != 0);
            boolean identical = XmlUtils.isIdenticalNormalizedWithoutValues((String)expectedResponse, (String)response);
            Assert.assertTrue((String)("Error during validation of service " + endpointUrl), (boolean)identical);
        }
    }

    private void registerHandler(SoapServer server, int testServiceId, Wsdl parser) throws WSDLException {
        TestUtils.registerService(server, testServiceId, parser);
    }

    private String formatEndpointAddress(String contextPath) {
        return String.format("%s:%s%s", HOST_URL, 9696, contextPath);
    }

    private String postRequest(SoapClient client, String request) {
        return client.post(request);
    }

    private String postRequest(SoapClient client, String request, String soapAction) {
        return client.post(soapAction, request);
    }

    protected KeyStore readKeyStore(URL keyStoreUrl, String keyStorePassword, String keyStoreType) {
        InputStream in = null;
        try {
            in = keyStoreUrl.openStream();
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(in, keyStorePassword.toCharArray());
            return ks;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class ClientBuilderImpl
    implements ClientBuilder {
        ClientBuilderImpl() {
        }

        @Override
        public SoapClient buildClient(String endpointUrl) {
            return SoapClient.builder().endpointUri("http://" + endpointUrl).build();
        }
    }
}

