/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.legacy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlValidationError;
import org.reficio.ws.legacy.SoapMessageBuilder;
import org.reficio.ws.legacy.WsdlContext;
import org.reficio.ws.legacy.WsdlUtils;
import org.reficio.ws.legacy.XmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class WsdlValidator {
    private static final Logger log = Logger.getLogger(WsdlValidator.class);
    private final WsdlContext wsdlContext;

    WsdlValidator(SoapMessageBuilder builder, Binding binding) {
        this.wsdlContext = new WsdlContext(builder, binding);
    }

    List<AssertionError> assertRequest(BindingOperation bindingOperation, String message, boolean strict) {
        ArrayList<XmlError> errors = new ArrayList<XmlError>();
        try {
            this.validateXml(message, errors);
            this.wsdlContext.getSoapVersion().validateSoapEnvelope(message, errors);
            if (errors.isEmpty()) {
                if (bindingOperation == null) {
                    errors.add(XmlError.forMessage((String)("Missing operation [" + bindingOperation.getName() + "] in wsdl definition")));
                } else {
                    Part[] inputParts = WsdlUtils.getInputParts(bindingOperation);
                    this.validateMessage(message, bindingOperation, inputParts, errors, false, strict);
                }
            }
        }
        catch (Exception e) {
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        return this.convertErrors(errors);
    }

    List<AssertionError> assertResponse(BindingOperation bindingOperation, String message, boolean strict) {
        ArrayList<XmlError> errors = new ArrayList<XmlError>();
        try {
            this.validateXml(message, errors);
            if (StringUtils.isBlank((CharSequence)message)) {
                if (!WsdlUtils.isOneWay(bindingOperation)) {
                    errors.add(XmlError.forMessage((String)"Response is missing or empty"));
                }
            } else {
                this.wsdlContext.getSoapVersion().validateSoapEnvelope(message, errors);
                if (errors.isEmpty()) {
                    if (bindingOperation == null) {
                        errors.add(XmlError.forMessage((String)("Missing operation [" + bindingOperation.getName() + "] in wsdl definition")));
                    } else {
                        Part[] outputParts = WsdlUtils.getOutputParts(bindingOperation);
                        this.validateMessage(message, bindingOperation, outputParts, errors, true, strict);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        return this.convertErrors(errors);
    }

    private void validateXml(String request, List<XmlError> errors) {
        try {
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setLoadLineNumbers();
            xmlOptions.setErrorListener(errors);
            xmlOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
            XmlUtils.createXmlObject(request, xmlOptions);
        }
        catch (XmlException e) {
            if (e.getErrors() != null) {
                errors.addAll(e.getErrors());
            }
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        catch (Exception e) {
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
    }

    private List<AssertionError> convertErrors(List<XmlError> errors) {
        if (errors.size() > 0) {
            ArrayList<AssertionError> response = new ArrayList<AssertionError>();
            for (XmlError error : errors) {
                AssertionError assertionError;
                XmlValidationError e;
                QName offendingQName;
                if (error instanceof XmlValidationError && (offendingQName = (e = (XmlValidationError)error).getOffendingQName()) != null) {
                    if (offendingQName.equals(new QName(this.wsdlContext.getSoapVersion().getEnvelopeNamespace(), "encodingStyle"))) {
                        log.debug((Object)"ignoring encodingStyle validation..");
                        continue;
                    }
                    if (offendingQName.equals(new QName(this.wsdlContext.getSoapVersion().getEnvelopeNamespace(), "mustUnderstand"))) {
                        log.debug((Object)"ignoring mustUnderstand validation..");
                        continue;
                    }
                }
                if (response.contains(assertionError = new AssertionError(error))) continue;
                response.add(assertionError);
            }
            return new ArrayList<AssertionError>(response);
        }
        return new ArrayList<AssertionError>();
    }

    private void validateMessage(String message, BindingOperation bindingOperation, Part[] parts, List<XmlError> errors, boolean isResponse, boolean strict) {
        try {
            if (!this.wsdlContext.hasSchemaTypes()) {
                errors.add(XmlError.forMessage((String)"Missing schema types for message"));
            } else if (!WsdlUtils.isOutputSoapEncoded(bindingOperation)) {
                XmlOptions xmlOptions = new XmlOptions();
                xmlOptions.setLoadLineNumbers();
                xmlOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
                XmlObject xml = XmlUtils.createXmlObject(message, xmlOptions);
                XmlObject[] paths = xml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';$this/env:Envelope/env:Body/env:Fault");
                if (paths.length > 0) {
                    this.validateSoapFault(bindingOperation, paths[0], errors);
                } else if (WsdlUtils.isRpc(this.wsdlContext.getDefinition(), bindingOperation)) {
                    this.validateRpcLiteral(bindingOperation, parts, xml, errors, isResponse, strict);
                } else {
                    this.validateDocLiteral(bindingOperation, parts, xml, errors, isResponse, strict);
                }
            } else {
                errors.add(XmlError.forMessage((String)"Validation of SOAP-Encoded messages not supported"));
            }
        }
        catch (XmlException e) {
            if (e.getErrors() != null) {
                errors.addAll(e.getErrors());
            }
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        catch (Exception e) {
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
    }

    private void validateDocLiteral(BindingOperation bindingOperation, Part[] parts, XmlObject msgXml, List<XmlError> errors, boolean isResponse, boolean strict) throws Exception {
        Part part = null;
        for (int c = 0; c < parts.length; ++c) {
            if ((!isResponse || WsdlUtils.isAttachmentOutputPart(parts[c], bindingOperation)) && (isResponse || WsdlUtils.isAttachmentInputPart(parts[c], bindingOperation))) continue;
            if (part != null) {
                if (strict) {
                    errors.add(XmlError.forMessage((String)"DocLiteral message must contain 1 body part definition"));
                }
                return;
            }
            part = parts[c];
        }
        QName elementName = part.getElementName();
        if (elementName != null) {
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';declare namespace ns='" + elementName.getNamespaceURI() + "';$this/env:Envelope/env:Body/ns:" + elementName.getLocalPart());
            if (paths.length == 1) {
                SchemaGlobalElement elm = this.wsdlContext.getSchemaTypeLoader().findElement(elementName);
                if (elm != null) {
                    this.validateMessageBody(errors, elm.getType(), paths[0]);
                    NodeList children = XmlUtils.getChildElements((Element)paths[0].getDomNode().getParentNode());
                    for (int d = 0; d < children.getLength(); ++d) {
                        QName childName = XmlUtils.getQName(children.item(d));
                        if (elementName.equals(childName)) continue;
                        XmlCursor cur = paths[0].newCursor();
                        cur.toParent();
                        cur.toChild(childName);
                        errors.add(XmlError.forCursor((String)("Invalid element [" + childName + "] in SOAP Body"), (XmlCursor)cur));
                        cur.dispose();
                    }
                } else {
                    errors.add(XmlError.forMessage((String)("Missing part type [" + elementName + "] in associated schema")));
                }
            } else {
                errors.add(XmlError.forMessage((String)("Missing message part with name [" + elementName + "]")));
            }
        } else if (part.getTypeName() != null) {
            QName typeName = part.getTypeName();
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';declare namespace ns='" + typeName.getNamespaceURI() + "';$this/env:Envelope/env:Body/ns:" + part.getName());
            if (paths.length == 1) {
                SchemaType type = this.wsdlContext.getSchemaTypeLoader().findType(typeName);
                if (type != null) {
                    this.validateMessageBody(errors, type, paths[0]);
                } else {
                    errors.add(XmlError.forMessage((String)"Missing part type in associated schema"));
                }
            } else {
                errors.add(XmlError.forMessage((String)("Missing message part with name:type [" + part.getName() + ":" + typeName + "]")));
            }
        }
    }

    private void validateMessageBody(List<XmlError> errors, SchemaType type, XmlObject msg) throws XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setLoadLineNumbers();
        xmlOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
        XmlCursor cur = msg.newCursor();
        HashMap<String, String> map = new HashMap<String, String>();
        while (cur.hasNextToken()) {
            if (!cur.toNextToken().isNamespace()) continue;
            map.put(cur.getName().getLocalPart(), cur.getTextValue());
        }
        xmlOptions.setUseDefaultNamespace();
        xmlOptions.setSaveOuter();
        String xmlText = msg.copy().changeType(type).xmlText(xmlOptions);
        xmlOptions.setLoadAdditionalNamespaces(map);
        XmlObject obj = type.getTypeSystem().parse(xmlText, type, xmlOptions);
        obj = obj.changeType(type);
        ArrayList<String> list = new ArrayList<String>();
        xmlOptions = new XmlOptions();
        xmlOptions.setErrorListener(list);
        xmlOptions.setValidateTreatLaxAsSkip();
        try {
            obj.validate(xmlOptions);
        }
        catch (Exception e) {
            log.error((Object)"Internal error", (Throwable)e);
            list.add("Internal Error - see error log for details - [" + e + "]");
        }
        for (int c = 0; c < list.size(); ++c) {
            XmlError error = (XmlError)list.get(c);
            if (error instanceof XmlValidationError) {
                String text;
                XmlCursor cursor;
                XmlValidationError validationError = (XmlValidationError)error;
                if (this.wsdlContext.getSoapVersion().shouldIgnore(validationError) || (validationError.getErrorCode().equals("base64Binary") || validationError.getErrorCode().equals("hexBinary")) && (cursor = validationError.getCursorLocation()).toParent() && ((text = cursor.getTextValue()).startsWith("cid:") || text.startsWith("file:"))) continue;
            }
            int line = error.getLine() == -1 ? 0 : error.getLine() - 1;
            errors.add(XmlError.forLocation((String)error.getMessage(), (String)error.getSourceName(), (int)(this.getLine(msg) + line), (int)error.getColumn(), (int)error.getOffset()));
        }
    }

    private int getLine(XmlObject object) {
        ArrayList list = new ArrayList();
        object.newCursor().getAllBookmarkRefs(list);
        for (int c = 0; c < list.size(); ++c) {
            if (!(list.get(c) instanceof XmlLineNumber)) continue;
            return ((XmlLineNumber)list.get(c)).getLine();
        }
        return -1;
    }

    private void validateRpcLiteral(BindingOperation bindingOperation, Part[] parts, XmlObject msgXml, List<XmlError> errors, boolean isResponse, boolean strict) throws Exception {
        if (parts.length == 0) {
            return;
        }
        XmlObject[] bodyParts = this.getRpcBodyPart(bindingOperation, msgXml, isResponse);
        if (bodyParts.length != 1) {
            errors.add(XmlError.forMessage((String)("Missing message wrapper element [" + WsdlUtils.getTargetNamespace(this.wsdlContext.getDefinition()) + "@" + bindingOperation.getName() + (isResponse ? "Response" : ""))));
        } else {
            XmlObject wrapper = bodyParts[0];
            for (int i = 0; i < parts.length; ++i) {
                Part part = parts[i];
                if (!isResponse ? WsdlUtils.isAttachmentInputPart(part, bindingOperation) : WsdlUtils.isAttachmentOutputPart(part, bindingOperation)) continue;
                XmlObject[] children = wrapper.selectChildren(new QName(part.getName()));
                if (children.length != 1) {
                    QName elementName = part.getElementName();
                    if (elementName != null) {
                        bodyParts = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';declare namespace ns='" + this.wsdlContext.getDefinition().getTargetNamespace() + "';declare namespace ns2='" + elementName.getNamespaceURI() + "';$this/env:Envelope/env:Body/ns:" + bindingOperation.getName() + (isResponse ? "Response" : "") + "/ns2:" + elementName.getLocalPart());
                        if (bodyParts.length == 1) {
                            SchemaGlobalElement elm = this.wsdlContext.getSchemaTypeLoader().findElement(elementName);
                            if (elm != null) {
                                this.validateMessageBody(errors, elm.getType(), bodyParts[0]);
                                continue;
                            }
                            errors.add(XmlError.forMessage((String)("Missing part type in associated schema for [" + elementName + "]")));
                            continue;
                        }
                        errors.add(XmlError.forMessage((String)("Missing message part with name [" + elementName + "]")));
                        continue;
                    }
                    errors.add(XmlError.forMessage((String)("Missing message part [" + part.getName() + "]")));
                    continue;
                }
                QName typeName = part.getTypeName();
                SchemaType type = this.wsdlContext.getSchemaTypeLoader().findType(typeName);
                if (type != null) {
                    this.validateMessageBody(errors, type, children[0]);
                    continue;
                }
                errors.add(XmlError.forMessage((String)("Missing type in associated schema for part [" + part.getName() + "]")));
            }
        }
    }

    private XmlObject[] getRpcBodyPart(BindingOperation bindingOperation, XmlObject msgXml, boolean isResponse) throws Exception {
        String ns = WsdlUtils.getSoapBodyNamespace(isResponse ? bindingOperation.getBindingOutput().getExtensibilityElements() : bindingOperation.getBindingInput().getExtensibilityElements());
        if (ns == null || ns.trim().length() == 0) {
            ns = WsdlUtils.getTargetNamespace(this.wsdlContext.getDefinition());
        }
        XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';declare namespace ns='" + ns + "';$this/env:Envelope/env:Body/ns:" + bindingOperation.getName() + (isResponse ? "Response" : ""));
        return paths;
    }

    private void validateSoapFault(BindingOperation bindingOperation, XmlObject msgXml, List<XmlError> errors) throws Exception {
        Map faults = bindingOperation.getBindingFaults();
        Iterator i = faults.values().iterator();
        ArrayList list = new ArrayList();
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setErrorListener(list);
        xmlOptions.setValidateTreatLaxAsSkip();
        msgXml.validate(xmlOptions);
        for (Object o : list) {
            if (o instanceof XmlError) {
                errors.add((XmlError)o);
                continue;
            }
            errors.add(XmlError.forMessage((String)o.toString()));
        }
        while (i.hasNext()) {
            BindingFault bindingFault = (BindingFault)i.next();
            String faultName = bindingFault.getName();
            Part[] faultParts = WsdlUtils.getFaultParts(bindingOperation, faultName);
            if (faultParts.length == 0) {
                log.warn((Object)("Missing fault parts in wsdl for fault [" + faultName + "] in bindingOperation [" + bindingOperation.getName() + "]"));
                continue;
            }
            if (faultParts.length != 1) {
                log.info((Object)("Too many fault parts in wsdl for fault [" + faultName + "] in bindingOperation [" + bindingOperation.getName() + "]"));
                continue;
            }
            Part part = faultParts[0];
            QName elementName = part.getElementName();
            if (elementName != null) {
                XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "'; declare namespace flt='" + this.wsdlContext.getSoapVersion().getFaultDetailNamespace() + "';declare namespace ns='" + elementName.getNamespaceURI() + "';//env:Fault/flt:detail/ns:" + elementName.getLocalPart());
                if (paths.length != 1) continue;
                SchemaGlobalElement elm = this.wsdlContext.getSchemaTypeLoader().findElement(elementName);
                if (elm != null) {
                    this.validateMessageBody(errors, elm.getType(), paths[0]);
                } else {
                    errors.add(XmlError.forMessage((String)("Missing fault part element [" + elementName + "] for fault [" + part.getName() + "] in associated schema")));
                }
                return;
            }
            if (part.getTypeName() == null) continue;
            QName typeName = part.getTypeName();
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "'; declare namespace flt='" + this.wsdlContext.getSoapVersion().getFaultDetailNamespace() + "';declare namespace ns='" + typeName.getNamespaceURI() + "';//env:Fault/flt:detail/ns:" + part.getName());
            if (paths.length != 1) continue;
            SchemaType type = this.wsdlContext.getSchemaTypeLoader().findType(typeName);
            if (type != null) {
                this.validateMessageBody(errors, type, paths[0]);
            } else {
                errors.add(XmlError.forMessage((String)("Missing fault part type [" + typeName + "] for fault [" + part.getName() + "] in associated schema")));
            }
            return;
        }
        XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "'; declare namespace flt='" + this.wsdlContext.getSoapVersion().getFaultDetailNamespace() + "';//env:Fault/flt:detail");
        if (paths.length == 0) {
            log.warn((Object)("Missing matching Fault in wsdl for bindingOperation [" + bindingOperation.getName() + "]"));
        } else {
            String xmlText = paths[0].xmlText(new XmlOptions().setSaveOuter());
            log.warn((Object)("Missing matching Fault in wsdl for Fault Detail element [" + XmlUtils.removeUnneccessaryNamespaces(xmlText) + "] in bindingOperation [" + bindingOperation.getName() + "]"));
        }
    }
}

