/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.server.responder;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.xml.transform.Source;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.SoapOperation;
import org.reficio.ws.builder.SoapOperationBuilder;
import org.reficio.ws.builder.core.SoapUtils;
import org.reficio.ws.server.OperationNotFoundException;
import org.reficio.ws.server.SoapServerException;
import org.reficio.ws.server.matcher.SoapOperationMatcher;
import org.reficio.ws.server.responder.RequestResponder;
import org.springframework.ws.soap.SoapMessage;

public abstract class AbstractResponder
implements RequestResponder {
    private final SoapBuilder builder;
    private final Binding binding;
    private final SoapOperationMatcher soapOperationMatcher;

    public SoapBuilder getBuilder() {
        return this.builder;
    }

    public AbstractResponder(SoapBuilder builder) {
        this.builder = builder;
        this.binding = builder.getBinding();
        this.soapOperationMatcher = new SoapOperationMatcher(builder.getBinding());
    }

    @Override
    public Source respond(SoapMessage message) {
        try {
            BindingOperation invokedOperation = this.soapOperationMatcher.getInvokedOperation(message);
            if (this.soapOperationMatcher.isRequestResponseOperation(invokedOperation)) {
                SoapOperationBuilder operation = SoapUtils.createOperation((SoapBuilder)this.builder, (Binding)this.binding, (BindingOperation)invokedOperation, (String)message.getSoapAction());
                return this.respond((SoapOperation)operation, message);
            }
            return null;
        }
        catch (OperationNotFoundException e) {
            throw new SoapServerException((Throwable)((Object)e));
        }
    }

    public abstract Source respond(SoapOperation var1, SoapMessage var2);
}

