/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.reficio.ws.common.ResourceUtils;
import org.reficio.ws.server.SoapServerException;
import org.reficio.ws.server.core.SoapServer;

@Ignore
public class PasswordLessKeystoreTest {
    public void generateKeyLessKeystore() throws Exception {
        URL keyStoreUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)"/keystores", (String)".keystore");
        InputStream in = keyStoreUrl.openStream();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, "changeit".toCharArray());
        in.close();
        String path = keyStoreUrl.getFile().replace(".keystore", "keyless2.keystore");
        File file = new File(path);
        FileOutputStream out = new FileOutputStream(file);
        Certificate certificate = ks.getCertificate("john");
        Assert.assertNotNull((Object)certificate);
        Key key = ks.getKey("john", "changeit".toCharArray());
        Assert.assertNotNull((Object)key);
        KeyStore keyLess = KeyStore.getInstance(KeyStore.getDefaultType());
        keyLess.load(null);
        keyLess.setKeyEntry("tom", key, "".toCharArray(), new Certificate[]{certificate});
        keyLess.store(out, "".toCharArray());
    }

    @Test
    public void trustStoreUrl() throws Exception {
        URL keyStoreUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)"/keystores", (String)"keyless.keystore");
        InputStream in = keyStoreUrl.openStream();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, null);
        in.close();
        Certificate certificate = ks.getCertificate("tom");
        Assert.assertNotNull((Object)certificate);
        Key key = ks.getKey("tom", "".toCharArray());
        Assert.assertNotNull((Object)key);
    }

    @Test
    public void testServerWithKeyLessKeystore_EmptyPwd() {
        URL keyStoreUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)"/keystores", (String)"keyless.keystore");
        SoapServer server = SoapServer.builder().httpsPort(9696).keyStoreUrl(keyStoreUrl).keyStorePassword("").build();
        server.start();
        server.stop();
    }

    @Test(expected=SoapServerException.class)
    public void testServerWithKeyLessKeystore_NullPwd() {
        URL keyStoreUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)"/keystores", (String)"keyless.keystore");
        SoapServer server = SoapServer.builder().httpsPort(9696).keyStoreUrl(keyStoreUrl).keyStorePassword(null).build();
        server.start();
        server.stop();
    }

    @Test(expected=SoapServerException.class)
    public void testServerWithKeyLessKeystore_WrongPwd() {
        URL keyStoreUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)"/keystores", (String)"keyless.keystore");
        SoapServer server = SoapServer.builder().httpsPort(9696).keyStoreUrl(keyStoreUrl).keyStorePassword("wrong_password").build();
        server.start();
        server.stop();
    }
}

