/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.server.protocol;

import java.io.IOException;
import java.io.InputStream;
import org.reficio.ws.server.protocol.SimpleSoapProtocolChooser;
import org.reficio.ws.server.protocol.SoapProtocolChooser;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapMessageFactory;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoapMessageFactory;
import org.springframework.ws.transport.TransportInputStream;

public class GenericSoapMessageFactory
implements SoapMessageFactory,
InitializingBean {
    private static final String REQUEST_CONTEXT_ATTRIBUTE = "GenericSoapMessageFactory";
    private final SaajSoapMessageFactory soap11 = new SaajSoapMessageFactory();
    private final SaajSoapMessageFactory soap12 = new SaajSoapMessageFactory();
    private SoapProtocolChooser soapProtocolChooser = new SimpleSoapProtocolChooser();

    private void setMessageFactoryForRequestContext(SaajSoapMessageFactory factory) {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        attributes.setAttribute(REQUEST_CONTEXT_ATTRIBUTE, (Object)factory, 0);
    }

    private SaajSoapMessageFactory getMessageFactoryForRequestContext() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (SaajSoapMessageFactory)attributes.getAttribute(REQUEST_CONTEXT_ATTRIBUTE, 0);
    }

    public void setSoapVersion(SoapVersion version) {
    }

    public void setSoapProtocolChooser(SoapProtocolChooser soapProtocolChooser) {
        this.soapProtocolChooser = soapProtocolChooser;
    }

    private void configureFactory(SaajSoapMessageFactory factory, SoapVersion version) {
        factory.setSoapVersion(version);
        factory.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.configureFactory(this.soap11, SoapVersion.SOAP_11);
        this.configureFactory(this.soap12, SoapVersion.SOAP_12);
    }

    public SoapMessage createWebServiceMessage() {
        return this.getMessageFactoryForRequestContext().createWebServiceMessage();
    }

    public SoapMessage createWebServiceMessage(InputStream inputStream) throws IOException {
        TransportInputStream transportInputStream;
        this.setMessageFactoryForRequestContext(this.soap11);
        if (inputStream instanceof TransportInputStream && this.soapProtocolChooser.useSoap12(transportInputStream = (TransportInputStream)inputStream)) {
            this.setMessageFactoryForRequestContext(this.soap12);
        }
        SaajSoapMessageFactory mf = this.getMessageFactoryForRequestContext();
        return mf.createWebServiceMessage(inputStream);
    }
}

