/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.server.protocol;

import java.io.IOException;
import java.util.Iterator;
import org.reficio.ws.server.protocol.SoapProtocolChooser;
import org.springframework.ws.transport.TransportInputStream;

public class SimpleSoapProtocolChooser
implements SoapProtocolChooser {
    private static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    private static final String CONTENT_TYPE_HEADER_CONTENT_SOAP_11 = "text/xml";

    @Override
    public boolean useSoap11(TransportInputStream transportInputStream) throws IOException {
        Iterator headerNames = transportInputStream.getHeaderNames();
        while (headerNames.hasNext()) {
            String headerName = (String)headerNames.next();
            Iterator headerValues = transportInputStream.getHeaders(headerName);
            while (headerValues.hasNext()) {
                String headerValue = (String)headerValues.next();
                if (!headerName.toLowerCase().contains(CONTENT_TYPE_HEADER_NAME) || !headerValue.trim().toLowerCase().contains(CONTENT_TYPE_HEADER_CONTENT_SOAP_11)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean useSoap12(TransportInputStream transportInputStream) throws IOException {
        return !this.useSoap11(transportInputStream);
    }
}

