/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.server;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.List;
import javax.xml.transform.Source;
import org.junit.Assert;
import org.junit.Test;
import org.reficio.ws.server.ServiceRegistrationException;
import org.reficio.ws.server.SoapServerException;
import org.reficio.ws.server.core.SoapServer;
import org.reficio.ws.server.responder.RequestResponder;
import org.springframework.ws.soap.SoapMessage;

public class SimpleServerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortAvailable(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static int getFreePort() {
        for (int portToCheck = 20000; portToCheck < 21000; ++portToCheck) {
            if (!SimpleServerTest.isPortAvailable(portToCheck)) continue;
            return portToCheck;
        }
        throw new SoapServerException("Crazy stuff is happening, no free port available");
    }

    public static SoapServer getServer() {
        SoapServer server = SoapServer.builder().httpPort(SimpleServerTest.getFreePort()).build();
        return server;
    }

    @Test
    public void startStop() {
        int port = SimpleServerTest.getFreePort();
        Assert.assertTrue((boolean)SimpleServerTest.isPortAvailable(port));
        SoapServer server = SoapServer.builder().httpPort(port).build();
        server.start();
        junit.framework.Assert.assertFalse((boolean)SimpleServerTest.isPortAvailable(port));
        server.stop();
        Assert.assertTrue((boolean)SimpleServerTest.isPortAvailable(port));
    }

    @Test
    public void startStopDestroy() {
        SoapServer server = SimpleServerTest.getServer();
        server.start();
        server.stop();
        server.destroy();
    }

    @Test
    public void startStopDestroyCannotResurrect() {
        SoapServer server = SimpleServerTest.getServer();
        server.start();
        server.stop();
        server.destroy();
        RuntimeException caught = null;
        try {
            server.start();
        }
        catch (RuntimeException ex) {
            caught = ex;
        }
        Assert.assertNotNull((Object)caught);
    }

    @Test
    public void registerCheck() {
        String contextPath = "/test";
        SoapServer server = SimpleServerTest.getServer();
        server.registerRequestResponder(contextPath, new RequestResponder(){

            public Source respond(SoapMessage message) {
                return null;
            }
        });
        List paths = server.getRegisteredContextPaths();
        Assert.assertEquals((long)paths.size(), (long)1L);
        Assert.assertEquals((Object)paths.toArray(new String[0])[0], (Object)contextPath);
    }

    @Test
    public void unregisterCheck() {
        String contextPath = "/test";
        SoapServer server = SimpleServerTest.getServer();
        server.registerRequestResponder(contextPath, new RequestResponder(){

            public Source respond(SoapMessage message) {
                return null;
            }
        });
        server.unregisterRequestResponder(contextPath);
        List paths = server.getRegisteredContextPaths();
        Assert.assertEquals((long)paths.size(), (long)0L);
    }

    @Test(expected=ServiceRegistrationException.class)
    public void doubleRegister() {
        String contextPath = "/test";
        SoapServer server = SimpleServerTest.getServer();
        server.registerRequestResponder(contextPath, new RequestResponder(){

            public Source respond(SoapMessage message) {
                return null;
            }
        });
        server.registerRequestResponder(contextPath, new RequestResponder(){

            public Source respond(SoapMessage message) {
                return null;
            }
        });
    }

    @Test(expected=NullPointerException.class)
    public void registerNullResponder() {
        String contextPath = "/test";
        SoapServer server = SimpleServerTest.getServer();
        server.registerRequestResponder(contextPath, null);
    }

    @Test(expected=NullPointerException.class)
    public void registerNullContextPath() {
        SoapServer server = SimpleServerTest.getServer();
        server.registerRequestResponder(null, new RequestResponder(){

            public Source respond(SoapMessage message) {
                return null;
            }
        });
    }

    @Test(expected=ServiceRegistrationException.class)
    public void unregisterNotExisting() {
        String contextPath = "/test";
        SoapServer server = SimpleServerTest.getServer();
        server.unregisterRequestResponder(contextPath);
    }
}

