/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.test;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import org.reficio.ws.SoapContext;
import org.reficio.ws.SoapException;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.core.Wsdl;
import org.reficio.ws.common.ResourceUtils;
import org.reficio.ws.server.core.SoapServer;
import org.reficio.ws.server.responder.AutoResponder;
import org.reficio.ws.server.responder.RequestResponder;
import org.reficio.ws.test.spock.Server;

public class ServerProcessor {
    private SoapServer server;
    private final String wsdl;
    private final String binding;
    private final String path;
    private final int port;
    private final Class testClass;

    public ServerProcessor(org.reficio.ws.test.junit.Server server, Class testClass) {
        this.wsdl = this.processUrl(server.wsdl());
        this.binding = server.binding();
        this.path = server.path();
        this.port = server.port();
        this.testClass = testClass;
    }

    public ServerProcessor(Server server, Class testClass) {
        this.wsdl = this.processUrl(server.wsdl());
        this.binding = server.binding();
        this.path = server.path();
        this.port = server.port();
        this.testClass = testClass;
    }

    private String processUrl(String wsdlUrl) {
        if (wsdlUrl == null) {
            return null;
        }
        if (wsdlUrl.startsWith("classpath:")) {
            return ResourceUtils.getResource((String)wsdlUrl.replace("classpath:", "")).toString();
        }
        return wsdlUrl;
    }

    public SoapServer initServer() {
        this.validate();
        URL wsdlUrl = this.getWsdlUrl(this.testClass);
        Wsdl parser = Wsdl.parse((URL)wsdlUrl);
        SoapBuilder builder = this.getBuilder(parser);
        this.server = this.construct();
        AutoResponder responder = this.getAutoResponder(builder);
        this.registerService(this.server, responder);
        this.server.start();
        return this.server;
    }

    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private SoapServer construct() {
        return SoapServer.builder().httpPort(this.port).build();
    }

    private void registerService(SoapServer server, AutoResponder responder) {
        server.registerRequestResponder(this.path, (RequestResponder)responder);
    }

    private AutoResponder getAutoResponder(SoapBuilder builder) {
        SoapContext context = SoapContext.builder().exampleContent(true).buildOptional(true).alwaysBuildHeaders(true).build();
        return new AutoResponder(builder, context);
    }

    private SoapBuilder getBuilder(Wsdl parser) {
        SoapBuilder builder = null;
        try {
            builder = parser.binding().name(this.binding).find();
        }
        catch (SoapException soapException) {
            // empty catch block
        }
        if (builder == null) {
            builder = parser.binding().localPart(this.binding).find();
        }
        Preconditions.checkNotNull((Object)builder, (Object)"Binding not found");
        return builder;
    }

    private URL getWsdlUrl(Class testClass) {
        URL wsdlUrl = null;
        try {
            wsdlUrl = ResourceUtils.getResource((Class)testClass, (String)this.wsdl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (wsdlUrl == null) {
            try {
                wsdlUrl = new URL(this.wsdl);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Wrong wsdl url", e);
            }
        }
        return wsdlUrl;
    }

    private void validate() {
        Preconditions.checkNotNull((Object)this.wsdl, (Object)"Wsdl url cannot be null");
        Preconditions.checkNotNull((Object)this.binding, (Object)"Binding name cannot be null");
        Preconditions.checkArgument((this.port >= 0 && this.port < 65535 ? 1 : 0) != 0, (Object)"Port has to be in range [0, 655535]");
    }
}

