(ns matrix-client-server-api.api.session-management
  (:require [matrix-client-server-api.core :refer [call-api check-required-params with-collection-format]])
  (:import (java.io File)))

(defn login-with-http-info
  "Authenticates the user.
  Authenticates the user, and issues an access token they can
use to authorize themself in subsequent requests.

If the client does not supply a ``device_id``, the server must
auto-generate one.

The returned access token must be associated with the ``device_id``
supplied by the client or generated by the server. The server may
invalidate any access token previously associated with that device. See
`Relationship between access tokens and devices`_."
  ([] (login-with-http-info nil))
  ([{:keys [body ]}]
   (call-api "/_matrix/client/r0/login" :post
             {:path-params   {}
              :header-params {}
              :query-params  {}
              :form-params   {}
              :body-param    body
              :content-types ["application/json"]
              :accepts       ["application/json"]
              :auth-names    []})))

(defn login
  "Authenticates the user.
  Authenticates the user, and issues an access token they can
use to authorize themself in subsequent requests.

If the client does not supply a ``device_id``, the server must
auto-generate one.

The returned access token must be associated with the ``device_id``
supplied by the client or generated by the server. The server may
invalidate any access token previously associated with that device. See
`Relationship between access tokens and devices`_."
  ([] (login nil))
  ([optional-params]
   (:data (login-with-http-info optional-params))))

(defn logout-with-http-info
  "Invalidates a user access token
  Invalidates an existing access token, so that it can no longer be used for
authorization."
  []
  (call-api "/_matrix/client/r0/logout" :post
            {:path-params   {}
             :header-params {}
             :query-params  {}
             :form-params   {}
             :content-types ["application/json"]
             :accepts       ["application/json"]
             :auth-names    ["accessToken"]}))

(defn logout
  "Invalidates a user access token
  Invalidates an existing access token, so that it can no longer be used for
authorization."
  []
  (:data (logout-with-http-info)))

