(ns rksm.cloxp-cljs.config
  (:require [rksm.cloxp-projects.core :as p]
            [leiningen.cljsbuild.config :as lein-cljsb]))
        

; cljs.build.api
; project/project-info
; clojurescript-build.api/output-directory

(defn cljsbuild-options-of-project
  [dir]
  (lein-cljsb/extract-options
   (p/project-info dir {:only [:cljsbuild]})))

(defn cljsbuild-builds-of-project
  [dir]
  (:builds (cljsbuild-options-of-project dir)))

(defn cljsbuild-options-of-namespace
  [dir]
  (lein-cljsb/extract-options
   (p/project-info dir {:only [:cljsbuild]})))

(comment
 (cljsbuild-options-of-project "/Users/robert/clojure/cloxp-com")
 (cljsbuild-builds-of-project "/Users/robert/clojure/cloxp-com")
 )