(ns sablono.core
  (:require [sablono.compiler :as compiler]))

(defmacro attrs
  "Compile `attributes` map into a JavaScript literal."
  [attributes]
  (compiler/compile-attrs nil attributes))

(defmacro html
  "Compile the Hiccup `form`. Always produces code that evaluates to
  React elements."
  [form]
  (compiler/compile-html form))

(defmacro html-expand
  "Macro expand the Hiccup `content`."
  [form]
  `(macroexpand `(html ~~form)))

