(defproject org.roman01la/sablono "0.8.1-5"
  :description "Lisp style templating for Facebook's React."
  :url "http://github.com/r0man/sablono"
  :author "r0man"
  :min-lein-version "2.0.0"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.9.0-alpha17"]
                 [org.clojure/clojurescript "1.9.908"]]
  :profiles {:dev      {:dependencies      [[criterium "0.4.4"]
                                            [devcards "0.2.3" :exclusions [sablono]]
                                            [doo "0.1.7"]
                                            [figwheel-sidecar "0.5.13"]
                                            [funcool/tubax "0.2.0"]
                                            [org.clojure/test.check "0.9.0"]
                                            [perforate-x "0.1.0"]]
                        :node-dependencies [[benchmark "1.0.0"]]
                        :plugins           [[lein-cljsbuild "1.1.4"]
                                            [lein-doo "0.1.7"]
                                            [lein-figwheel "0.5.13"]
                                            [lein-npm "0.5.0"]
                                            [perforate "0.3.4"]]
                        :resource-paths    ["test-resources" "target"]}
             :provided {:dependencies [[org.clojure/clojurescript "1.9.908"]]}
             :repl     {:dependencies [[com.cemerick/piggieback "0.2.2"]]
                        :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}}
  :aliases {"ci"     ["do"
                      ["clean"]
                      ["npm" "install"]
                      ["test" ":default"]
                      ["doo" "node" "nodejs" "once"]
                      ["doo" "node" "benchmark" "once"]]
            "deploy" ["do" "clean," "deploy" "clojars"]}
  :clean-targets ^{:protect false} [:target-path]
  :cljsbuild {:builds
              [{:id           "benchmark"
                :compiler
                              {:asset-path    "target/benchmark/out"
                               :main          sablono.benchmark
                               :output-dir    "target/benchmark/out"
                               :output-to     "target/benchmark/sablono.js"
                               :optimizations :none
                               :target        :nodejs
                               :pretty-print  false
                               :verbose       true
                               :install-deps  false
                               :npm-deps      {"@roman01la/preact"       "8.2.5-2"
                                               "preact-render-to-string" "3.6.3"}}
                :source-paths ["src" "benchmark"]}
               {:id           "devcards"
                :compiler
                              {:asset-path    "devcards"
                               :main          sablono.test.runner
                               :output-to     "target/public/sablono.js"
                               :output-dir    "target/public/devcards"
                               :optimizations :none
                               :pretty-print  false
                               :source-map    true
                               :verbose       true
                               :install-deps  false
                               :npm-deps      {"@roman01la/preact"       "8.2.5-2"
                                               "preact-render-to-string" "3.6.3"}}
                :figwheel     true
                :source-paths ["src" "test"]}
               {:id           "nodejs"
                :compiler
                              {:asset-path    "target/nodejs/out"
                               :main          sablono.test.runner
                               :optimizations :none
                               :output-dir    "target/nodejs/out"
                               :output-to     "target/nodejs/sablono.js"
                               :pretty-print  false
                               :source-map    true
                               :target        :nodejs
                               :verbose       true
                               :install-deps  false
                               :npm-deps      {"@roman01la/preact"       "8.2.5-2"
                                               "preact-render-to-string" "3.6.3"}}
                :source-paths ["src" "test"]}
               {:id           "none"
                :compiler
                              {:asset-path    "target/none/out"
                               :main          sablono.test.runner
                               :output-to     "target/none/sablono.js"
                               :output-dir    "target/none/out"
                               :optimizations :none
                               :pretty-print  false
                               :source-map    true
                               :verbose       true
                               :install-deps  false
                               :npm-deps      {"@roman01la/preact"       "8.2.5-2"
                                               "preact-render-to-string" "3.6.3"}}
                :source-paths ["src" "test"]}
               {:id           "advanced"
                :compiler
                              {:asset-path    "target/advanced/out"
                               :main          sablono.test.runner
                               :output-dir    "target/advanced/out"
                               :output-to     "target/advanced/sablono.js"
                               :optimizations :advanced
                               :pretty-print  false
                               :verbose       true
                               :install-deps  false
                               :npm-deps      {"@roman01la/preact"       "8.2.5-2"
                                               "preact-render-to-string" "3.6.3"}}
                :source-paths ["src" "test"]}
               {:id           "sample"
                :compiler
                              {:asset-path    "out"
                               :main          example.core
                               :output-dir    "test-resources/public/out"
                               :output-to     "test-resources/public/sablono.js"
                               :optimizations :none
                               :pseudo-names  false
                               :pretty-print  false
                               :verbose       true
                               :install-deps  false
                               :npm-deps      {"@roman01la/preact"       "8.2.5-2"
                                               "preact-render-to-string" "3.6.3"}}
                :figwheel     true
                :source-paths ["src" "sample"]}]}
  :deploy-repositories [["releases" :clojars]]
  :perforate {:environments [{:namespaces [sablono.benchmark]}]}
  :test-selectors {:benchmark :benchmark
                   :default   (complement :benchmark)})
