(ns scrum.devtools.logger
  (:require [clojure.data :as cd]))

;; re-frame's `debug` interceptor
;; https://github.com/Day8/re-frame/blob/master/src/re_frame/std_interceptors.cljc#L17
(defn attach! [state]
  (add-watch state ::logger
             (fn [_ _ old-state new-state]
               (let [[before after] (cd/diff old-state new-state)
                     changed? (or (some? before) (some? after))]
                 (when changed?
                   (js/console.group "STATE CHANGED:" (-> (js/Date.) .toLocaleTimeString))
                   (js/console.log "BEFORE:" before)
                   (js/console.log "AFTER:" after)
                   (js/console.groupEnd))))))

(defn detach! [state]
  (remove-watch state ::logger))
